#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#
# Pluto 26.6.00: rcvd_line -> rcvd
#

if(description)
{
 script_id(10068);
 script_version ("$Revision: 1.21 $");
 script_cve_id("CVE-1999-0612");
 name["english"] = "Finger";
 name["francais"] = "Finger";
 name["portugues"] = "Finger";
 script_name(english:name["english"], francais:name["francais"], portugues:name["portugues"]);
 
 desc["english"] = "The 'finger' service provides useful information
to attackers, since it allow them to gain usernames, check if a machine
is being used, and so on... 

Risk factor : Low

Solution : comment out the 'finger' line in /etc/inetd.conf";

 desc["francais"] = "Le service 'finger' donne des informations utiles
aux crackers, puisqu'il leur permet d'obtenir des noms d'utilisateurs,
de dterminer si une machine est en train d'etre utilise, etc...
Il est recommand que vous vous dbarassiez de ce
service.

Facteur de risque : faible.

Solution : Dsactivez ce service en mettant un diese (#)
au debut de la ligne 'finger' dans /etc/inetd.conf";

 desc["portugues"] = "O servio 'finger' prov informaes teis para
crackers,  uma vez que permite  eles ganharem usernames, verificarem 
se a mquina est sendo usada, etc.

Fator de risco : Baixo.

Soluo : Desativar o servio finger no /etc/inetd.conf, bastando 
colocar um '#' no incio da linha correspondente, no esquecer depois
da modificaao de: killall -HUP inetd .";

script_description(english:desc["english"], francais:desc["francais"],
		portugues:desc["portugues"]);
 
 summary["english"] = "Checks for finger";
 summary["francais"] = "Verifie la prsence du service finger";
 summary["portugues"] = "Verifica se o servio finger est habilitado";

script_summary(english:summary["english"], francais:summary["francais"],
		portugues:summary["portugues"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison",
		francais:"Ce script est Copyright (C) 1999 Renaud Deraison",
		portugues:"Este script  Copyright (C) 1999 Renaud Deraison");
 family["english"] = "Useless services";
 family["francais"] = "Services inutiles";
 family["portugues"] = "Servios menos utilizados";
 script_family(english:family["english"], francais:family["francais"],
 		portugues:family["portugues"]);
 script_dependencie("find_service.nes");
 script_require_ports("Services/finger", 79);
 exit(0);
}

#
# The script code starts here
#

port = get_kb_item("Services/finger");
if(!port)port = 79;
if(get_port_state(port))
{
 soc = open_sock_tcp(port);
 if(soc)
 {
  buf = string("\r\n");
  send(socket:soc, data:buf);
  data = recv(socket:soc, length:1024);
  if(egrep(pattern:".*User|[lL]ogin|logged.*", string:data))
  {
  	security_warning(port);
	set_kb_item(name:"finger/active", value:TRUE);
	}
  close(soc);
 }
}
