# Copyright 2002 by John Lampe...j_lampe@bellsouth.net
# thanks for signatures and packet dumps from Matt N., William Craig,
# Bill King, jay at kinetic dot org,  HD Moore
#
# Modifications by rd: don't use forge_udp_packet() but use a regular
# udp socket instead ; use Nessus's SNMP functions, don't hardcode the
# use of the "public" SNMP community. Use SNMP/sysDesc is present already,
# simplified the search through the sysDesc string.
#
#

#
# See the Nessus Scripts License for details
#
#

desc["english"] = "
The remote host is a Wireless Access Point.
You should ensure that the proper physical and logical controls exist
around the AP.

Risk factor : Medium/Low";



if(description)
{
 script_id(11026);
 script_version ("$Revision: 1.6.2.1 $");

 name["english"] = "Access Point detection";
 script_name(english:name["english"]);


 script_description(english:desc["english"]);

 summary["english"] = "Detect Access Point";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"This script is Copyright (C) 2002 John Lampe...j_lampe@bellsouth.net");
 family["english"] = "General";
 script_family(english:family["english"]);
 script_dependencie("snmp_sysDesc.nasl");
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");


# try to find APs via web management interface
port = 80;
pos[0] = "WLAN";    # SMC
pos[1] = "ireless";
pos[2] = "SetExpress.shm";   #cisco 350


if(get_port_state(port))
{
 soc = http_open_socket(port);
 if(soc) {
  send(socket:soc, data:http_get(item:"/", port:port));
  answer = http_recv(socket:soc);
  http_close_socket(soc);
  if (answer) {
    for (i=0; pos[i]; i = i + 1) {
          if ((egrep(pattern:pos[i], string:answer))) {
              security_warning(0);
              exit(0);
          }
    }
  }
 }
}


# try find APs via ftp
port = 21;
ftppos[0] = "Cisco BR500";
ftppos[1] = "WLAN AP";

if(get_port_state(port))
{
soc = open_sock_tcp(port);
if (soc) {
  r = recv_line(socket:soc, length:512);
  close(soc);
  if (r) {
      for (i=0; ftppos[i]; i = i + 1) {
          if ((egrep(pattern:ftppos[i], string:r))) {
               security_warning(0);
               exit(0);
          }
      }
  }
 }
}

# try to find APs via snmp port (rely on them leaving public community string)


#
# Solaris comes with a badly configured snmpd which
# always reply with the same value. We make sure the answers
# we receive are not in the list of default values usually
# answered...
#
function valid_snmp_value(value)
{
 if("/var/snmp/snmpdx.st" >< value)return(0);
 if("/etc/snmp/conf" >< value)return(0);
 if( (strlen(value) == 1) && (ord(value[0]) < 32) )return(0);
 return(1);
}

community = get_kb_item("SNMP/community");
if(!community)exit(0);

if(get_udp_port_state(161))
{
 soc = open_sock_udp(161);

# put char string identifiers below
 snmppos[0]="AP-";                     # Compaq AP
 snmppos[1]="Base Station";
 snmppos[2]="WaveLan";
 snmppos[3]="WavePOINT-II";# Orinoco WavePOINT II Wireless AP
 snmppos[4]="AP-1000";     # Orinoco AP-1000 Wireless AP
 snmppos[5]="Cisco BR500"; # Cisco Aironet Wireless Bridge


# create GET sysdescr call

mydata = get_kb_item("SNMP/sysDesc");
if(!mydata) {
 snmpobjid = raw_string(0x2b,0x06,0x01,0x02,0x01,0x01,0x01,0x00);            
 version = raw_string(0x02 , 0x01 , 0x00);
 snmplen = strlen(community) % 256;
 community = raw_string(0x04, snmplen) + community;
 pdu_type = raw_string(0xa0, 0x19);             
 request_id = raw_string(0x02,0x01,0xde);
 error_stat = raw_string(0x02,0x01,0x00);
 error_index = raw_string(0x02,0x01,0x00);
 tie_off = raw_string(0x05,0x00);


 snmpstring = version + community + pdu_type + request_id + error_stat
+ error_index + raw_string(0x30,0x0e,0x30,0x0c,0x06,0x08) + snmpobjid +
tie_off;

 tot_len = strlen(snmpstring);
 tot_len = tot_len % 256;

 snmpstring = raw_string(0x30, tot_len) +  snmpstring;

 send(socket:soc, data:snmpstring);

 mydata = recv(socket:soc, length:1025);
 if(strlen(mydata) < 48)exit(0);
 if(!mydata)exit(0);

 check_val = valid_snmp_value(value:mydata);
 if (!check_val) exit(0);
}


flag = 0;

for (psi=0; snmppos[psi]; psi = psi + 1) {
        if(snmppos[psi] >< mydata) {
            security_warning(0);
            exit(0);
        }
 }
}
