######################################################################
# global flags and constants for ZWiki

# page types available in wikis by default - use a allowed_page_types
# folder lines property to customize. See ZWikiPage.py for more types.
ALLOWED_PAGE_TYPES = (
    'msgstxprelinkfitissuehtml',
    'msgrstprelinkfitissue',    
    'msgwwmlprelinkfitissue',
    'html',
    )
DEFAULT_PAGE_TYPE = ALLOWED_PAGE_TYPES[0] # fallback default new page type
AUTO_UPGRADE = 1                        # upgrade old pages when viewed
DISABLE_JAVASCRIPT = 1                  # disable javascript in edits ?
LARGE_FILE_SIZE = 1024*1024             # unused ?
MAX_NEW_LINES_DISPLAY = 200             # truncate each diff (and mailout)
MAX_OLD_LINES_DISPLAY = 20              # at this number of lines
PAGE_METATYPE = 'ZWiki Page'
ISSUE_COLOURS = (
    # a list of strings like 'category,status,severity,colour' any of
    # which may be empty.  Can be overridden with an 'issue_colours'
    # folder lines property.
    ',open,critical ,#ff2222',
    ',open,serious  ,#ff6060',
    ',open,normal   ,#ffbbbb',
    ',open,minor    ,#ffdddd',
    ',open,wishlist ,#ffe0e0',
    ',open,         ,#ffe0e0',
    ',pending,      ,#ffcc77',
    ',closed,       ,#e0f0e0',
    ',,             ,#e0e0e0',
    )

# for reStructuredText:
# You can customize the default encoding by creating a file
# sitecustomize.py somewhere in yout PYTHONPATH:
#  import sys
#  sys.setdefaultencoding("iso-8859-1")
#import sys
#sys.setdefaultencoding("iso-8859-1")
#hmm not right

# CMF stuff
PAGE_PORTALTYPE = 'Wiki Page'
default_regs = {
    'create': 'nonanon',
    'edit': 'nonanon',
    'comment': 'nonanon',
    'move': 'owners',
    }
