# catalog awareness for zwiki pages
# based on Casey Duncan's DTMLDocumentExt 0.1
#
# todo: may want to make these all safe against Catalog errors

import string
from Utils import DLOG

###########################################################################
# CLASS CatalogAwareness
###########################################################################

class CatalogAwareness:
    """
    Holds most of ZWikiPage's catalog awareness code.
    Zope's CatalogAwareness didn't work for me and this one
    is a little more flexible or at least familiar.
    """
    NOT_CATALOGED=0
    _properties=(
        {'id':'NOT_CATALOGED', 'type': 'boolean', 'mode': 'w'},
        )

    # cataloging methods

    def getCatalogId(self):
        """Return the id of the appropriate catalog to use."""
        # make this work in unit test context too
        folder_noaq = getattr(self.folder(),'aq_base',self.folder())
        
        if hasattr(self.aq_base, 'SITE_CATALOG'):
            return self.aq_base.SITE_CATALOG
        elif hasattr(folder_noaq, 'SITE_CATALOG'):
            return folder_noaq.SITE_CATALOG
        # I want portal_catalog to be acquired
        elif hasattr(self.folder(),'portal_catalog'):
            return 'portal_catalog'
        else:
            return 'Catalog'

    def catalog(self):
        return getattr(self.folder(),self.getCatalogId(),None)

    def hasCatalog(self):
        return self.catalog() != None

    def isCatalogable(self):
        return not getattr(self, 'NOT_CATALOGED', 0)

    def url(self):
        """Return the absolute object path"""
        return string.join(self.getPhysicalPath(),'/')

    def index_object(self):
        """A common method to allow Findables to index themselves."""
        if (self.hasCatalog() and self.isCatalogable()):
            DLOG('indexing',self.url(),'in',self.getCatalogId())
            #DLOG(self.id(),"'s last_edit_time is",self.last_edit_time)
            self.catalog().catalog_object(self, self.url())
            self.is_indexed_ = 1
            #DLOG('indexing '+self.id()+'done')

    def unindex_object(self):
        """A common method to allow Findables to unindex themselves."""
        #DLOG('unindexing '+self.id())
        if self.hasCatalog():
            self.catalog().uncatalog_object(self.url())
            self.is_indexed_ = 0

    def reindex_object(self):
        """Reindex the object in the Catalog"""
        if getattr(self, 'is_indexed_', 0):
            self.unindex_object()
        self.index_object()

# enable catalog awareness for common ZMI operations
# have to do this in __init__ because of an import loop ?
