#C A sampler of flipflops (period 2 oscillators)
#C Top row: blinker, bipole, beacon, clapping hands or toad, gear, flywheel,
#C traffic lights.
#C Second row (billiards patterns): great on-off, lightbulb,
#C quad (or barber-pole intersection), revolver, scrubber, skewed quad,
#C snake pit, spark coil, test-tube baby.
#C Flip-flops in the third row are unnamed.
#C See also BILLIARDS and POLES.
#C Collected by ESR.

## Simple flipflops:

#B blinker
#L blinker
#C Also known as "flasher"
#K p2
#P 1 0
***
#E

#B bipole
#L bipole
#C Also known as "short barberpole".
#C This pattern can be stretched.
#K p2 extensible
#P -2 -2
**...
*.*..
.....
..*.*
...**
#E

#B beacon
#L beacon
#K p2
#P -2 -2
**..
**..
..**
..**
#E

#B clapping-hands
#L clapping hands
#C Also known as "toad".
#K p2
#P -1 -2
*.
**
**
.*
#E

#B gear
#L gear
#K p2
#P -3 -3
...*....
...*.*..
.*......
......**
**......
......*.
..*.*...
....*...
#E

#B flywheel
#L flywheel
#K p2
#P -1 -1
.*..
.*.*
*.*.
..*.
#E

#B traffic-lights
#L traffic lights
#K p2
#P -4 -4
....*....
....*....
....*....
.........
***...***
.........
....*....
....*....
....*....
#E

## Billiards flipflops:

#B great-on-off
#L great on-off
#K p2 billiards
#P -4 -3
..**....
.*..*...
.*.**...
**.*.**.
....**.*
.......*
....***.
....*...
#E

#B lightbulb
#L lightbulb
#K p2 billiards
#P -2 -4
.**.*..
.*.**..
.......
..***..
.*...*.
.*...*.
..*.*..
*.*.*.*
**...**
#E

#B negentropy
#L negentropy
#K p2 billiards
#P -4 -4
......**....
......**....
............
....****..**
**.*..*.*..*
.*.*...**.*.
*..*....*.**
**..****....
............
....**......
....**......
#E

#B quad
#L quad
#C The quad is also known as the "barber-pole intersection".
#K p2 billiards
#P -3 -2
**..**
*..*.*
.*....
....*.
*.*..*
**..**
#E

#B revolver
#L revolver
#K p2 billiards
#P -3 -5
**....**
.*....*.
.*.**.*.
..*..*..
...*....
.....*..
.**.....
.....**.
..*.....
....*...
..*..*..
.*.**.*.
.*....*.
**....**
#E

#B scrubber
#L scrubber
#K p2 billiards
#P -5 -5
....*......
..***......
.*.........
.*..***....
**.*...*...
...*...*...
...*...*.**
....***..*.
.........*.
......***..
......*....
#E

#B skewed-quad
#L skewed quad
#K p2 billiards
#P -3 -3
.**....
.*...**
..*.*.*
.......
*.*.*..
**...*.
....**.
#E

#B snake-pit
#L snake pit
#K p2 billiards
#P -3 -3
*.**.**
**.*.*.
......*
***.***
*......
.*.*.**
**.**.*
#E

#B spark-coil
#L spark coil
#K p2 billiards
#P -3 -3
**....**
*.*..*.*
..*..*..
*.*..*.*
**....**
#E

#B test-tube-baby
#L test tube baby
#K p2 billiards
#P -3 -3
**....**
*.*..*.*
..*..*..
..*..*..
...**...
#E

## Unnamed flipflops:

#B unnamed-1
#K p2
#P -3 -3
....***
**.....
*.*.**.
.......
..*.*..
.*.....
.**....
#E

#B unnamed-2
#P -2 -3
..*...
..*.*.
*.....
.*****
*.....
..*.*.
..*...
#E

#L A SAMPLER OF FLIPFLOPS
#L 
#K p2 sampler
#I :blinker		 20   0
#I :bipole		 40   0
#I :beacon		 60   0
#I :clapping-hands	 80   0
#I :gear		100   0
#I :flywheel		120   0
#I :traffic-lights	140   0

#I :great-on-off          0  20
#I :lightbulb	         20  20
#I :negentropy		 40  20
#I :quad	         60  20
#I :revolver		 80  20
#I :scrubber		100  20
#I :skewed-quad		120  20
#I :snake-pit		140  20
#I :spark-coil		160  20
#I :test-tube-baby	180  20

#I :unnamed-1		 80  40 
#I :unnamed-2		100  40 

