'\"
'\" Generated from ./modules/textutil/textutil.man by mpexpand with fmt.nroff
'\"
.so man.macros
.TH "textutil" n 0.5 textutil "Texts and strings utils"
.BS
.SH NAME
textutil \- Procedures to manipulate texts and strings.
.SH "SYNOPSIS"
package require \fBTcl 8.2\fR
.sp
package require \fBtextutil ?0.5?\fR
.sp
\fBtextutil::adjust\fR \fIstring args\fR\fR
.sp
\fBtextutil::splitx\fR \fIstring\fR ?\fIregexp\fR?\fR
.sp
\fBtextutil::tabify\fR \fIstring\fR ?\fInum\fR?\fR
.sp
\fBtextutil::tabify2\fR \fIstring\fR ?\fInum\fR?\fR
.sp
\fBtextutil::trim\fR \fIstring\fR ?\fIregexp\fR?\fR
.sp
\fBtextutil::trimleft\fR \fIstring\fR ?\fIregexp\fR?\fR
.sp
\fBtextutil::trimright\fR \fIstring\fR ?\fIregexp\fR?\fR
.sp
\fBtextutil::untabify\fR \fIstring\fR ?\fInum\fR?\fR
.sp
\fBtextutil::untabify2\fR \fIstring\fR ?\fInum\fR?\fR
.sp
\fBtextutil::strRepeat\fR \fItext num\fR\fR
.sp
.BE
.SH "DESCRIPTION"
The \fBtextutil\fR package provides commands that manipulate
strings or texts (a.k.a. long strings or string with embedded newlines
or paragraphs).
.PP
The complete set of procedures is described below.
.TP
\fBtextutil::adjust\fR \fIstring args\fR\fR
Do a justification on the \fIstring\fR according to \fIargs\fR.  The
string is taken as one big paragraph, ignoring any newlines.  Then the
line is formatted according to the options used, and the command
return a new string with enough lines to contain all the printable
chars in the input string. A line is a set of chars between the
beginning of the string and a newline, or between 2 newlines, or
between a newline and the end of the string. If the input string is
small enough, the returned string won't contain any newlines.
.sp
By default, any occurrence of spaces characters or tabulation are
replaced by a single space so each word in a line is separated from
the next one by exactly one space char, and this forms a \fIreal\fR
line. Each \fIreal\fR line is placed in a \fIlogical\fR line, which
have exactly a given length (see \fI-length\fR option below). The
\fIreal\fR line may have a lesser length. Again by default, any
trailing spaces are ignored before returning the string (see
\fI-full\fR option below). The following options may be used after the
\fIstring\fR parameter, and change the way the command place a
\fIreal\fR line in a \fIlogical\fR line.
.RS
.TP
-full \fIboolean\fR
If set to \fBfalse\fR, any trailing space chars are deleted before
returning the string. If set to \fBtrue\fR, any trailing space
chars are left in the string. Default to \fBfalse\fR.
.TP
-justify (\fBcenter|left|plain|right\fR)
Set the justification of the returned string to \fBcenter\fR,
\fBleft\fR, \fBplain\fR or \fBright\fR. By default, it is set
to \fBleft\fR.  The justification means that any line in the
returned string but the last one is build according to the value. If
the justification is set to \fBplain\fR and the number of printable
chars in the last line is less than 90% of the length of a line (see
\fI-length\fR), then this line is justified with the \fBleft\fR
value, avoiding the expansion of this line when it is too small. The
meaning of each value is:
.RS
.TP
\fBcenter\fR
The real line is centered in the logical line. If needed, a set of
space char are added at the beginning (half of the needed set) and at
the end (half of the needed set) of the line if required (see the
option \fI-full\fR).
.TP
\fBleft\fR
The real line is set on the left of the logical line. It means that
there are no space chars at the beginning of this line. If required,
all needed space chars are added at the end of the line (see the
option \fI-full\fR).
.TP
\fBplain\fR
The real line is exactly set in the logical line. It means that there
are no leading or trailing space chars. All the needed space chars are
added in the \fIreal\fR line, between 2 (or more) words.
.TP
\fBright\fR
The real line is set on the right of the logical line. It means that
there are no space chars at the end of this line, and there may be
some space chars at the beginning, despite of the \fI-full\fR option.
.RE
.TP
-length \fIinteger\fR
Set the length of the \fIlogical\fR line in the string to
\fIinteger\fR.  \fIinteger\fR must be a positive integer
value. Defaults to \fI72\fR.
.TP
-strictlength \fIboolean\fR
If set to \fBfalse\fR, a line can exceed the specified
\fI-length\fR if a single word is longer than \fI-length\fR. If set to
\fBtrue\fR, words that are longer than \fI-length\fR are split so
that no line exceeds the specified \fI-length\fR. Defaults to
\fBfalse\fR.
.RE
.TP
\fBtextutil::splitx\fR \fIstring\fR ?\fIregexp\fR?\fR
Split the \fIstring\fR and return a list. The string is split
according to the regular expression \fIregexp\fR instead of a simple
list of chars. Note that if you add parenthesis into the \fIregexp\fR,
the parentheses part of separator would be added into list as
additional element. If the \fIstring\fR is empty the result is the
empty list, like for \fBsplit\fR. If \fIregexp\fR is empty the
\fIstring\fR is split at every character, like \fBsplit\fR does.
The regular expression \fIregexp\fR defaults to "[\\t \\r\\n]+".
.TP
\fBtextutil::tabify\fR \fIstring\fR ?\fInum\fR?\fR]
Tabify the \fIstring\fR by replacing any substring of \fInum\fR space
chars by a tabulation and return the result as a new string. \fInum\fR
defaults to 8.
.TP
\fBtextutil::tabify2\fR \fIstring\fR ?\fInum\fR?\fR]
Similar to \fBtextutil::tabify\fR this command tabifies the
\fIstring\fR and returns the result as a new string. A different
algorithm is used however. Instead of replacing any substring of
\fInum\fR spaces this comand works more like an editor. \fInum\fR
defaults to 8.
.sp
Each line of the text in \fIstring\fR is treated as if there are
tabstops every \fInum\fR columns. Only sequences of space characters
containing more than one space character and found immediately before
a tabstop are replaced with tabs.
.TP
\fBtextutil::trim\fR \fIstring\fR ?\fIregexp\fR?\fR]
Remove in \fIstring\fR any leading and trailing substring according to
the regular expression \fIregexp\fR and return the result as a new
string.  This apply on any \fIline\fR in the string, that is any
substring between 2 newline chars, or between the beginning of the
string and a newline, or between a newline and the end of the string,
or, if the string contain no newline, between the beginning and the
end of the string.
The regular expression \fIregexp\fR defaults to "[ \\t]+".
.TP
\fBtextutil::trimleft\fR \fIstring\fR ?\fIregexp\fR?\fR]
Remove in \fIstring\fR any leading substring according to the regular
expression \fIregexp\fR and return the result as a new string. This
apply on any \fIline\fR in the string, that is any substring between
2 newline chars, or between the beginning of the string and a newline,
or between a newline and the end of the string, or, if the string
contain no newline, between the beginning and the end of the string.
The regular expression \fIregexp\fR defaults to "[ \\t]+".
.TP
\fBtextutil::trimright\fR \fIstring\fR ?\fIregexp\fR?\fR]
Remove in \fIstring\fR any trailing substring according to the regular
expression \fIregexp\fR and return the result as a new string. This
apply on any \fIline\fR in the string, that is any substring between
2 newline chars, or between the beginning of the string and a newline,
or between a newline and the end of the string, or, if the string
contain no newline, between the beginning and the end of the string.
The regular expression \fIregexp\fR defaults to "[ \\t]+".
.TP
\fBtextutil::untabify\fR \fIstring\fR ?\fInum\fR?\fR]
Untabify the \fIstring\fR by replacing any tabulation char by a
substring of \fInum\fR space chars and return the result as a new
string. \fInum\fR defaults to 8.
.TP
\fBtextutil::untabify2\fR \fIstring\fR ?\fInum\fR?\fR]
Untabify the \fIstring\fR by replacing any tabulation char by a
substring of at most \fInum\fR space chars and return the result as a
new string. Unlike \fBtextutil::untabify\fR each tab is not replaced
by a fixed number of space characters.  The command overlays each line
in the \fIstring\fR with tabstops every \fInum\fR columns instead and
replaces tabs with just enough space characters to reach the next
tabstop. This is the complement of the actions taken by
\fBtextutil::tabify2\fR. \fInum\fR defaults to 8.
.sp
There is one asymmetry though: A tab can be replaced with a single
space, but not the other way around.
.TP
\fBtextutil::strRepeat\fR \fItext num\fR\fR
The implementation depends on the core executing the package. Used
\fBstring repeat\fR if it is present, or a fast tcl implementation
if it is not. Returns a string containing the \fItext\fR repeated
\fInum\fR times. The repetitions are joined without characters between
them. A value of \fInum\fR <= 0 causes the command to return an empty
string.
.SH "SEE ALSO"
regexp(n), split(n), string(n)
.SH "KEYWORDS"
string, regular expression
