<?php
// $Id: class_pf.inc,v 1.4 2002/11/29 10:45:46 dijkstra Exp $
require_once("class_graph.inc");

class PF_Graph extends Graph {
    function PF_Graph() {
	// get all the sensible defaults from our parent class
	$this->init(); 
    }
    function execute($url) {
	$this->url2options($url);

	// and add a few private things
	$this->shortcut = array_merge($this->shortcut, array(
	    "pf" => array(
		"brief" => array(
		    "dsdefinition" => array(
			"DEF:A=".$this->get("rrdfile").":bytes:AVERAGE "),
		    "graphdefinition" => array(
			'COMMENT:"            min          avg          max          last\n"',
			"AREA:A#00FF00:'bytes'",
			"GPRINT:A:MIN:'%6.2lf %sBps'",
			"GPRINT:A:AVERAGE:'%6.2lf %sBps'",
			"GPRINT:A:MAX:'%6.2lf %sBps'",
			"GPRINT:A:LAST:'%6.2lf %sBps'")),
		"all" => array(
		    "dsdefinition" => array(
			"DEF:A=".$this->get("rrdfile").":bytes_v4_in:AVERAGE ",
			"DEF:B=".$this->get("rrdfile").":bytes_v4_out:AVERAGE ",
			"DEF:C=".$this->get("rrdfile").":bytes_v6_in:AVERAGE ",
			"DEF:D=".$this->get("rrdfile").":bytes_v6_out:AVERAGE ",
			"DEF:E=".$this->get("rrdfile").":packets_v4_in_pass:AVERAGE ",
			"DEF:F=".$this->get("rrdfile").":packets_v4_in_drop:AVERAGE ",
			"DEF:G=".$this->get("rrdfile").":packets_v4_out_pass:AVERAGE ",
			"DEF:H=".$this->get("rrdfile").":packets_v4_out_drop:AVERAGE ",
			"DEF:J=".$this->get("rrdfile").":packets_v6_in_pass:AVERAGE ",
			"DEF:K=".$this->get("rrdfile").":packets_v6_in_drop:AVERAGE ",
			"DEF:L=".$this->get("rrdfile").":packets_v6_out_pass:AVERAGE ",
			"DEF:M=".$this->get("rrdfile").":packets_v6_out_drop:AVERAGE ",
			"DEF:N=".$this->get("rrdfile").":states_entries:MAX ",
			"DEF:O=".$this->get("rrdfile").":states_searches:AVERAGE ",
			"DEF:P=".$this->get("rrdfile").":states_inserts:AVERAGE ",
			"DEF:Q=".$this->get("rrdfile").":states_removals:AVERAGE ",
			"DEF:R=".$this->get("rrdfile").":counters_match:AVERAGE ",
			"DEF:S=".$this->get("rrdfile").":counters_badoffset:AVERAGE ",
			"DEF:T=".$this->get("rrdfile").":counters_fragment:AVERAGE ",
			"DEF:U=".$this->get("rrdfile").":counters_short:AVERAGE ",
			"DEF:V=".$this->get("rrdfile").":counters_normalize:AVERAGE ",
			"DEF:W=".$this->get("rrdfile").":counters_memory:AVERAGE "),    
		    "graphdefinition" => array(
			'COMMENT:"                     min          avg          max          last\n"',
			'LINE1:A#000000:"bytes_v4_in"',
			"GPRINT:A:MIN:'        %4.2lf %sBps'",
			"GPRINT:A:AVERAGE:'%4.2lf %sBps'",
			"GPRINT:A:MAX:'%4.2lf %sBps'",
			'GPRINT:A:LAST:"%4.2lf %sBps\n"',
			'LINE1:B#0B0B0B:"bytes_v4_out"',
			"GPRINT:B:MIN:'       %4.2lf %sBps'",
			"GPRINT:B:AVERAGE:'%4.2lf %sBps'",
			"GPRINT:B:MAX:'%4.2lf %sBps'",
			'GPRINT:B:LAST:"%4.2lf %sBps\n"',
			'LINE1:C#161616:"bytes_v6_in"',
			"GPRINT:C:MIN:'        %4.2lf %sBps'",
			"GPRINT:C:AVERAGE:'%4.2lf %sBps'",
			"GPRINT:C:MAX:'%4.2lf %sBps'",
			'GPRINT:C:LAST:"%4.2lf %sBps\n"',
			'LINE1:D#212121:"bytes_v6_out"',
			"GPRINT:D:MIN:'       %4.2lf %sBps'",
			"GPRINT:D:AVERAGE:'%4.2lf %sBps'",
			"GPRINT:D:MAX:'%4.2lf %sBps'",
			'GPRINT:D:LAST:"%4.2lf %sBps\n"',
			'LINE1:E#2C2C2C:"packets_v4_in_pass"',
			"GPRINT:E:MIN:' %4.2lf     '",
			"GPRINT:E:AVERAGE:'%4.2lf     '",
			"GPRINT:E:MAX:'%4.2lf     '",
			'GPRINT:E:LAST:"%4.2lf\n"',
			'LINE1:F#373737:"packets_v4_in_drop"',
			"GPRINT:F:MIN:' %4.2lf     '",
			"GPRINT:F:AVERAGE:'%4.2lf     '",
			"GPRINT:F:MAX:'%4.2lf     '",
			'GPRINT:F:LAST:"%4.2lf\n"',
			'LINE1:G#424242:"packets_v4_out_pass"',
			"GPRINT:G:MIN:'%4.2lf     '",
			"GPRINT:G:AVERAGE:'%4.2lf     '",
			"GPRINT:G:MAX:'%4.2lf     '",
			'GPRINT:G:LAST:"%4.2lf\n"',
			'LINE1:H#4D4D4D:"packets_v4_out_drop"',
			"GPRINT:H:MIN:'%4.2lf     '",
			"GPRINT:H:AVERAGE:'%4.2lf     '",
			"GPRINT:H:MAX:'%4.2lf     '",
			'GPRINT:H:LAST:"%4.2lf\n"',
			'LINE1:J#585858:"packets_v6_in_pass"',
			"GPRINT:J:MIN:' %4.2lf     '",
			"GPRINT:J:AVERAGE:'%4.2lf     '",
			"GPRINT:J:MAX:'%4.2lf     '",
			'GPRINT:J:LAST:"%4.2lf\n"',
			'LINE1:K#636363:"packets_v6_in_drop"',
			"GPRINT:K:MIN:' %4.2lf     '",
			"GPRINT:K:AVERAGE:'%4.2lf     '",
			"GPRINT:K:MAX:'%4.2lf     '",
			'GPRINT:K:LAST:"%4.2lf\n"',
			'LINE1:L#6E6E6E:"packets_v6_out_pass"',
			"GPRINT:L:MIN:'%4.2lf     '",
			"GPRINT:L:AVERAGE:'%4.2lf     '",
			"GPRINT:L:MAX:'%4.2lf     '",
			'GPRINT:L:LAST:"%4.2lf\n"',
			'LINE1:M#797979:"packets_v6_out_drop"',
			"GPRINT:M:MIN:'%4.2lf     '",
			"GPRINT:M:AVERAGE:'%4.2lf     '",
			"GPRINT:M:MAX:'%4.2lf     '",
			'GPRINT:M:LAST:"%4.2lf\n"',
			'LINE1:N#848484:"states_entries"',
			"GPRINT:N:MIN:'     %4.2lf     '",
			"GPRINT:N:AVERAGE:'%4.2lf    '",
			"GPRINT:N:MAX:'%4.2lf     '",
			'GPRINT:N:LAST:"%4.2lf\n"',
			'LINE1:O#8F8F8F:"states_searches"',
			"GPRINT:O:MIN:'    %4.2lf    '",
			"GPRINT:O:AVERAGE:'%4.2lf   '",
			"GPRINT:O:MAX:'%4.2lf   '",
			'GPRINT:O:LAST:"%4.2lf\n"',
			'LINE1:P#9A9A9A:"states_inserts"',
			"GPRINT:P:MIN:'     %4.2lf     '",
			"GPRINT:P:AVERAGE:'%4.2lf     '",
			"GPRINT:P:MAX:'%4.2lf     '",
			'GPRINT:P:LAST:"%4.2lf\n"',
			'LINE1:Q#A5A5A5:"states_removals"',
			"GPRINT:Q:MIN:'    %4.2lf     '",
			"GPRINT:Q:AVERAGE:'%4.2lf     '",
			"GPRINT:Q:MAX:'%4.2lf     '",
			'GPRINT:Q:LAST:"%4.2lf\n"',
			'LINE1:R#B0B0B0:"counters_match"',
			"GPRINT:R:MIN:'     %4.2lf     '",
			"GPRINT:R:AVERAGE:'%4.2lf    '",
			"GPRINT:R:MAX:'%4.2lf    '",
			'GPRINT:R:LAST:"%4.2lf\n"',
			'LINE1:S#BBBBBB:"counters_badoffset"',
			"GPRINT:S:MIN:' %4.2lf     '",
			"GPRINT:S:AVERAGE:'%4.2lf     '",
			"GPRINT:S:MAX:'%4.2lf     '",
			'GPRINT:S:LAST:"%4.2lf\n"',
			'LINE1:T#C6C6C6:"counters_fragment"',
			"GPRINT:T:MIN:'  %4.2lf     '",
			"GPRINT:T:AVERAGE:'%4.2lf     '",
			"GPRINT:T:MAX:'%4.2lf     '",
			'GPRINT:T:LAST:"%4.2lf\n"',
			'LINE1:U#D1D1D1:"counters_short"',
			"GPRINT:U:MIN:'     %4.2lf     '",
			"GPRINT:U:AVERAGE:'%4.2lf     '",
			"GPRINT:U:MAX:'%4.2lf     '",
			'GPRINT:U:LAST:"%4.2lf\n"',
			'LINE1:V#DCDCDC:"counters_normalize"',
			"GPRINT:V:MIN:' %4.2lf     '",
			"GPRINT:V:AVERAGE:'%4.2lf     '",
			"GPRINT:V:MAX:'%4.2lf     '",
			'GPRINT:V:LAST:"%4.2lf\n"',
			'LINE1:W#E7E7E7:"counters_memory"',
			"GPRINT:W:MIN:'    %4.2lf     '",
			"GPRINT:W:AVERAGE:'%4.2lf     '",
			"GPRINT:W:MAX:'%4.2lf     '",
			'GPRINT:W:LAST:"%4.2lf\n"')),
		"state" => array(
		    "dsdefinition" => array(
			"DEF:N=".$this->get("rrdfile").":states_entries:MAX ",
			"DEF:O=".$this->get("rrdfile").":states_searches:AVERAGE ",
			"DEF:P=".$this->get("rrdfile").":states_inserts:AVERAGE ",
			"DEF:Q=".$this->get("rrdfile").":states_removals:AVERAGE ",
			"CDEF:NQ=0,Q,- "),
		    "graphdefinition" => array(
			'COMMENT:"                     min    avg    max    last\n"',
			'AREA:N#00FF00:"states_entries"',
			"GPRINT:N:MIN:'%4.2lf'",
			"GPRINT:N:AVERAGE:'%4.2lf'",
			"GPRINT:N:MAX:'%4.2lf'",
			'GPRINT:N:LAST:"%4.2lf\n"',
			'LINE1:P#0000FF:"states_inserts "',
			"GPRINT:P:MIN:'%4.2lf'",
			"GPRINT:P:AVERAGE:'%4.2lf'",
			"GPRINT:P:MAX:'%4.2lf'",
			'GPRINT:P:LAST:"%4.2lf\n"',
			'LINE1:NQ#FF0000:"states_removals"',
			"GPRINT:Q:MIN:'%4.2lf'",
			"GPRINT:Q:AVERAGE:'%4.2lf'",
			"GPRINT:Q:MAX:'%4.2lf'",
			'GPRINT:Q:LAST:"%4.2lf\n"')),
		"performance" => array(
		    "dsdefinition" => array(
			'COMMENT:"                     min      avg      max      last\n"',
			"DEF:O=".$this->get("rrdfile").":states_searches:AVERAGE ",
			"DEF:R=".$this->get("rrdfile").":counters_match:AVERAGE ",
			"DEF:S=".$this->get("rrdfile").":counters_badoffset:AVERAGE ",
			"DEF:T=".$this->get("rrdfile").":counters_fragment:AVERAGE ",
			"DEF:U=".$this->get("rrdfile").":counters_short:AVERAGE ",
			"DEF:V=".$this->get("rrdfile").":counters_normalize:AVERAGE ",
			"DEF:W=".$this->get("rrdfile").":counters_memory:AVERAGE "),    
		    "graphdefinition" => array(
			'LINE1:O#FFD900:"states_searches   "',
			"GPRINT:O:MIN:'%4.2lf'",
			"GPRINT:O:AVERAGE:'%4.2lf'",
			"GPRINT:O:MAX:'%4.2lf'",
			'GPRINT:O:LAST:"%4.2lf\n"',
			'LINE1:R#FD6724:"counters_match    "',
			"GPRINT:R:MIN:'%4.2lf'",
			"GPRINT:R:AVERAGE:'%4.2lf'",
			"GPRINT:R:MAX:'%4.2lf'",
			'GPRINT:R:LAST:"%4.2lf\n"',
			'LINE1:S#E61800:"counters_badoffset"',
			"GPRINT:S:MIN:'%4.2lf'",
			"GPRINT:S:AVERAGE:'%4.2lf'",
			"GPRINT:S:MAX:'%4.2lf'",
			'GPRINT:S:LAST:"%4.2lf\n"',
			'LINE1:T#AB2934:"counters_fragment "',
			"GPRINT:T:MIN:'%4.2lf'",
			"GPRINT:T:AVERAGE:'%4.2lf'",
			"GPRINT:T:MAX:'%4.2lf'",
			'GPRINT:T:LAST:"%4.2lf\n"',
			'LINE1:U#B2888B:"counters_short    "',
			"GPRINT:U:MIN:'%4.2lf'",
			"GPRINT:U:AVERAGE:'%4.2lf'",
			"GPRINT:U:MAX:'%4.2lf'",
			'GPRINT:U:LAST:"%4.2lf\n"',
			'LINE1:V#CC91BA:"counters_normalize"',
			"GPRINT:V:MIN:'%4.2lf'",
			"GPRINT:V:AVERAGE:'%4.2lf'",
			"GPRINT:V:MAX:'%4.2lf'",
			'GPRINT:V:LAST:"%4.2lf\n"',
			'LINE1:W#6A2990:"counters_memory   "',
			"GPRINT:W:MIN:'%4.2lf'",
			"GPRINT:W:AVERAGE:'%4.2lf'",
			"GPRINT:W:MAX:'%4.2lf'",
			"GPRINT:W:LAST:'%4.2lf\n'")))));

	$this->graphsettings["rawcmdline"] .=" -v 'pf'";
	$this->graphdefaults = array_merge($this->graphdefaults,
					   $this->shortcut["pf"]["state"]);

	$this->url2options($url);
    }
}
?>
