<?php
// $Id: class_if.inc,v 1.9 2002/11/29 10:45:46 dijkstra Exp $
require_once("class_graph.inc");

class IF_Graph extends Graph {
    function IF_Graph() {
	// get all the sensible defaults from our parent class
	$this->init();
    }

    function execute($url) {	
	$this->url2options($url);
	// Four major display modes:
	// if=brief|bits|packets|all
	$this->shortcut = array_merge($this->shortcut, array(
	    "if" => array(
		"brief" => array(
		    "dsdefinition" => array(
			"DEF:A=".$this->get("rrdfile").":ibytes:AVERAGE",
			"DEF:B=".$this->get("rrdfile").":obytes:AVERAGE",
			"CDEF:inb=A,8,*",
			"CDEF:outb=B,8,*",
			"CDEF:ioutb=0,outb,-"),
		    "graphdefinition" => array(
			"HRULE:0#000000",
			"AREA:inb#00FF00:'in'",
			"GPRINT:A:AVERAGE:'%6.2lf %sbps\g'",
			"AREA:ioutb#00FFFF:'out'" ,
			"GPRINT:outb:AVERAGE:'%6.2lf %sbps'")),
		"bits" => array(
		    "dsdefinition" => array(
			'DEF:in='.$this->get("rrdfile").':ibytes:AVERAGE',
			'DEF:out='.$this->get("rrdfile").':obytes:AVERAGE',
			'DEF:inp='.$this->get("rrdfile").':ipackets:AVERAGE',
			'DEF:outp='.$this->get("rrdfile").':opackets:AVERAGE',
			'DEF:coll='.$this->get("rrdfile").':collisions:AVERAGE',
			// bits per second
			'CDEF:inb=in,8,*',
			'CDEF:outb=out,8,*',
			// outbound bits per second negated
			'CDEF:noutb=outb,-1,*',
			// 2% extra at each bound (+x/-x) to ensure that we see the packetloss lines
			'CDEF:pmax=inb,100,/,102,*',
			'CDEF:nmax=noutb,100,/,102,*',
			// percentage of collisions
			'CDEF:totp=inp,outp,+',
			'CDEF:per=coll,totp,/,100,*',
			'CDEF:p0=per,0,EQ,INF,0,IF',
			'CDEF:p10=per,10,LE,INF,0,IF,per,0,GT,INF,0,IF,MIN',
			'CDEF:p20=per,20,LE,INF,0,IF,per,10,GT,INF,0,IF,MIN',
			'CDEF:p30=per,30,LE,INF,0,IF,per,20,GT,INF,0,IF,MIN',
			'CDEF:p40=per,40,LE,INF,0,IF,per,30,GT,INF,0,IF,MIN',
			'CDEF:p50=per,50,LE,INF,0,IF,per,40,GT,INF,0,IF,MIN',
			'CDEF:p60=per,60,LE,INF,0,IF,per,50,GT,INF,0,IF,MIN',
			'CDEF:p70=per,70,LE,INF,0,IF,per,60,GT,INF,0,IF,MIN',
			'CDEF:p80=per,80,LE,INF,0,IF,per,70,GT,INF,0,IF,MIN',
			'CDEF:p90=per,80,LE,INF,0,IF,per,80,GT,INF,0,IF,MIN',
			'CDEF:p100=per,100,LE,INF,0,IF,per,90,GT,INF,0,IF,MIN',
			// negative percentages
			'CDEF:n0=p0,-1,*',
			'CDEF:n10=p10,-1,*',
			'CDEF:n20=p20,-1,*',
			'CDEF:n30=p30,-1,*',
			'CDEF:n40=p40,-1,*',
			'CDEF:n50=p50,-1,*',
			'CDEF:n60=p60,-1,*',
			'CDEF:n70=p70,-1,*',
			'CDEF:n80=p80,-1,*',
			'CDEF:n90=p90,-1,*',
			'CDEF:n100=p100,-1,*'),
		    "graphdefinition" => array(
			'LINE1:pmax',
			'LINE1:nmax',
			'COMMENT:"               min          avg          max          last\n"',
			'AREA:inb#00FF00:"in     "',
			'GPRINT:inb:MIN:" %6.2lf %sbps"',
			'GPRINT:inb:AVERAGE:"%6.2lf %sbps"',
			'GPRINT:inb:MAX:"%6.2lf %sbps"',
			'GPRINT:inb:LAST:"%6.2lf %sbps\n"',
			'STACK:p0#FAFFFA', 
			'STACK:p10#FFFFE6',
			'STACK:p20#FFD900',
			'STACK:p30#FD6724',
			'STACK:p40#E61800',
			'STACK:p50#AB2934',
			'STACK:p60#B2888B',
			'STACK:p70#CC91BA',
			'STACK:p80#6A2990',
			'STACK:p90#0571B0',
			'STACK:p100#000000',
			'AREA:noutb#00FFFF:"out     "',
			'GPRINT:outb:MIN:"%6.2lf %sbps"',
			'GPRINT:outb:AVERAGE:"%6.2lf %sbps"',
			'GPRINT:outb:MAX:"%6.2lf %sbps"',
			'GPRINT:outb:LAST:"%6.2lf %sbps\n"',
			'COMMENT:packetloss',
			'GPRINT:per:MIN:"%6.2lf%%    "',
			'GPRINT:per:AVERAGE:"%6.2lf%%    "',
			'GPRINT:per:MAX:"%6.2lf%%    "',
			'GPRINT:per:LAST:"%6.2lf%%\n"',
			'STACK:n0#FAFFFA:" 0%  "',
			'STACK:n10#FFFFE6:" <10%"',
			'STACK:n20#FFD900:" <20%"',
			'STACK:n30#FD6724:" <30%"',
			'STACK:n40#E61800:" <40%"',
			'STACK:n50#AB2934:" <50%\n"',
			'STACK:n60#B2888B:" <60%"',
			'STACK:n70#CC91BA:" <70%"',
			'STACK:n80#6A2990:" <80%"',
			'STACK:n90#0571B0:" <90%"',
			'STACK:n100#000000:" <100%"')),
		"packets" => array(
		    "dsdefinition" => array(
			"DEF:A=".$this->get("rrdfile").":ipackets:AVERAGE",
			"DEF:B=".$this->get("rrdfile").":opackets:AVERAGE",
			"DEF:C=".$this->get("rrdfile").":imcasts:AVERAGE",
			"DEF:D=".$this->get("rrdfile").":omcasts:AVERAGE",
			"DEF:E=".$this->get("rrdfile").":ierrors:AVERAGE",
			"DEF:F=".$this->get("rrdfile").":oerrors:AVERAGE",
			"DEF:G=".$this->get("rrdfile").":collisions:AVERAGE",
			"DEF:H=".$this->get("rrdfile").":drops:AVERAGE"),
		    "graphdefinition" => array(
			"AREA:A#00FF00:'ipackets'",
			"GPRINT:A:AVERAGE:'%.0lf\g'",
			"LINE1:B#00FFFF:'opackets'",
			"GPRINT:B:AVERAGE:'%.0lf\g'",
			"LINE1:C#0000FF:'imcasts'",
			"GPRINT:C:AVERAGE:'%.0lf\g'",
			"LINE1:D#FF00FF:'omcasts'",
			"GPRINT:D:AVERAGE:'%.0lf\g'",
			"LINE1:E#FF0000:'ierrors'",
			"GPRINT:E:AVERAGE:'%.0lf\g'",
			"LINE1:F#8B0000:'oerrors'",
			"GPRINT:F:AVERAGE:'%.0lf\g'",
			"LINE1:G#888888:'collisions'",
			"GPRINT:G:AVERAGE:'%.0lf\g'",
			"LINE1:H#000000:'drops'",
			"GPRINT:H:AVERAGE:'%.0lf\g'")),
		"all" => array(
		    "dsdefinition" => array(
			"DEF:in=".$this->get("rrdfile").":ibytes:AVERAGE",
			"DEF:out=".$this->get("rrdfile").":obytes:AVERAGE",
			"DEF:inp=".$this->get("rrdfile").":ipackets:AVERAGE",
			"DEF:outp=".$this->get("rrdfile").":opackets:AVERAGE",
			"DEF:inm=".$this->get("rrdfile").":imcasts:AVERAGE",
			"DEF:outm=".$this->get("rrdfile").":omcasts:AVERAGE",
			"DEF:ierr=".$this->get("rrdfile").":ierrors:AVERAGE",
			"DEF:oerr=".$this->get("rrdfile").":oerrors:AVERAGE",
			"DEF:coll=".$this->get("rrdfile").":collisions:AVERAGE",
			"DEF:drop=".$this->get("rrdfile").":drops:AVERAGE"),
		    "graphdefinition" => array(
			"HRULE:0#000000",
			'COMMENT:"           min          avg          max          last\n"',
			"AREA:in#00FF00:'in '",
			"GPRINT:in:MIN:' %6.2lf %sbps'",
			"GPRINT:in:AVERAGE:'%6.2lf %sbps'",
			"GPRINT:in:MAX:'%6.2lf %sbps'",
			'GPRINT:in:LAST:"%6.2lf %sbps\n"',
			"LINE1:out",
			"LINE1:out#00FFFF:'out '" ,
			"GPRINT:out:MIN:'%6.2lf %sbps'",
			"GPRINT:out:AVERAGE:'%6.2lf %sbps'",
			"GPRINT:out:MAX:'%6.2lf %sbps'",
			'GPRINT:out:LAST:"%6.2lf %sbps\n"',
			"LINE1:inp#222222:'inp '" ,
			"GPRINT:inp:MIN:'%6.2lf %sbps'",
			"GPRINT:inp:AVERAGE:'%6.2lf %sbps'",
			"GPRINT:inp:MAX:'%6.2lf %sbps'",
			'GPRINT:inp:LAST:"%6.2lf %sbps\n"',
			"LINE1:outp#444444:'outp'" ,
			"GPRINT:outp:MIN:'%6.2lf %sbps'",
			"GPRINT:outp:AVERAGE:'%6.2lf %sbps'",
			"GPRINT:outp:MAX:'%6.2lf %sbps'",
			'GPRINT:outp:LAST:"%6.2lf %sbps\n"',
			"LINE1:inm#666666:'inm '" ,
			"GPRINT:inm:MIN:'%6.2lf %sbps'",
			"GPRINT:inm:AVERAGE:'%6.2lf %sbps'",
			"GPRINT:inm:MAX:'%6.2lf %sbps'",
			'GPRINT:inm:LAST:"%6.2lf %sbps\n"',
			"LINE1:outm#888888:'outm'" ,
			"GPRINT:outm:MIN:'%6.2lf %sbps'",
			"GPRINT:outm:AVERAGE:'%6.2lf %sbps'",
			"GPRINT:outm:MAX:'%6.2lf %sbps'",
			'GPRINT:outm:LAST:"%6.2lf %sbps\n"',
			"LINE1:ierr#aaaaaa:'ierr'" ,
			"GPRINT:ierr:MIN:'%6.2lf %sbps'",
			"GPRINT:ierr:AVERAGE:'%6.2lf %sbps'",
			"GPRINT:ierr:MAX:'%6.2lf %sbps'",
			'GPRINT:ierr:LAST:"%6.2lf %sbps\n"',
			"LINE1:oerr#cccccc:'oerr'" ,
			"GPRINT:oerr:MIN:'%6.2lf %sbps'",
			"GPRINT:oerr:AVERAGE:'%6.2lf %sbps'",
			"GPRINT:oerr:MAX:'%6.2lf %sbps'",
			'GPRINT:oerr:LAST:"%6.2lf %sbps\n"',
			"LINE1:coll#dddddd:'coll'" ,
			"GPRINT:coll:MIN:'%6.2lf %sbps'",
			"GPRINT:coll:AVERAGE:'%6.2lf %sbps'",
			"GPRINT:coll:MAX:'%6.2lf %sbps'",
			'GPRINT:coll:LAST:"%6.2lf %sbps\n"',
			"LINE1:drop#ffffff:'drop'" ,
			"GPRINT:drop:MIN:'%6.2lf %sbps'",
			"GPRINT:drop:AVERAGE:'%6.2lf %sbps'",
			"GPRINT:drop:MAX:'%6.2lf %sbps'",
			'GPRINT:drop:LAST:"%6.2lf %sbps\n"')))));

	$this->graphdefaults = array_merge($this->graphdefaults,
					   $this->shortcut["if"]["brief"]);
	$this->graphsettings["rawcmdline"] .=" -v 'if(".$this->get("name").")'";
	$this->url2options($url);
    }
}
?>
