#
# Check for bad permissions on a web server
#

if(description)
{
 script_id(10498);
 script_version ("$Revision: 1.19 $");
 
 name["english"] = "Test HTTP dangerous methods";
 name["francais"] = "Teste les mthodes HTTP dangereuses";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "
Misconfigured web servers allows remote clients to perform
dangerous HTTP methods such as PUT and DELETE. This script
checks if they are enabled and can be run

Risk factor : Medium/Serious";


 desc["francais"] = "
Certains serveurs web mal configurs permettent aux clients
d'effectuer les mthodes DELETE et PUT. Ce script vrifie
si elles sont actives et si elles peuvent tre lances";


 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Verifies the access rights to the web server (PUT, DELETE)";
 summary["francais"] = "Vrifie les droits d'accs au serveur web (PUT, DELETE)";
 
 script_summary(english:summary["english"], francais:summary["francais"]);
 # Integrist check verifies if the PUT and DELETE methods are _disabled_
 # i.e. the web server should return a 501 error instead of 403
 # With IIS, there is no way to get a 5xx error code.
 script_add_preference(name:"Integrist test", type:"checkbox", value:"no");

 script_category(ACT_MIXED_ATTACK); # mixed
 
 
 script_copyright(english:"This script is Copyright (C) 2000 Michel Arboi",
		francais:"Ce script est Copyright (C) 2000 Michel Arboi");
 family["english"] = "Remote file access";
 family["francais"] = "Accs aux fichiers distants";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "no404.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

integrist = script_get_preference("Integrist test");
if (!integrist) integrist="no";

function exists(file, port)
{
 _soc = open_sock_tcp(port);
 req = http_get(item:file, port:port);
 send(socket:_soc, data:req);
 r = recv_line(socket:_soc, length:4096);
 close(_soc);
 if(ereg(pattern:"^HTTP/[0-9]\.[0-9] 200 .*", string:r))
   return(1);
 else
  return(0);
}


port = get_kb_item("Services/www");
if (!port) port = 80;

# Is this necessary?
if (!get_port_state(port)) exit(0);

soc = open_sock_tcp(port);

if (soc) {
 for (i=1; exists(file:string("/puttest", i,".html"), port:port); i = i+1)
 {
   if(i > 20)exit(0); # we could not test this server - it always replie with a 200 code 
 } 
 name = string("/puttest",i,".html");
 #display(name, " is not installed\n");
 c = crap(length:77, data:"A quick brown fox jumps over the lazy dog");
 req = http_put(item:name, port:port, data:c);
 send(socket:soc, data:req);
	
 l = recv_line(socket:soc,length:1024);
 close(soc);
 #display(l);
 upload=0;
 if (exists(port:port, file:name)) {
  upload=1;
  security_hole(port:port, protocol:"tcp",
data: string("We could upload the file '",name, "' onto your web server\nThis allows an attacker to run arbitrary code on your server, or set a trojan horse\nSolution : disable this method\nRisk factor : High") );
 } else {
   if("yes" >< integrist)
    {
  if (" 403 " >< l) {
   #display("answer = ", l, "\n");
   security_warning(port:port, protocol:"tcp",
data:string("It seems that the PUT method is enabled on your web server\nAlthough we could not exploit this, you'd better disable it\nSolution : disable this method\nRisk factor : Serious"));
    }
  }
 }

 
 # Leave file for next test (DELETE). Dirty...

 if (! upload) {
  if(safe_checks())exit(0);
  name="/index.html";
  if (! (exists(port:port, file:name))) {
   name="/index.htm";
   if (! (exists(port:port, file:name))) {
     name = "/default.asp";
     if(! (exists(port:port, file:name)))
      {
       name = "/default.htm";
       if(! (exists(port:port, file:name)))
       {
        name = "/index.php";
	if(! (exists(port:port, file:name)))
        {
        #display("Cannot find a file to delete\n");
	name = "/";
        }
       }
      }
     }
   }
 }



 
 
 soc = open_sock_tcp(port);
 req = http_delete(item:name, port:port);
 send(socket:soc, data: req);
 l = recv_line(socket:soc, length:1024);
 
 if (" 200 " >< l) {
  e = exists(port:port, file:name);
  if(!e)
    security_hole(port:port, protocol:"tcp",
data: string("We could DELETE the file '", name, "'on your web server\nThis allows an attacker to destroy some of your pages\nSolution : disable this method\nRisk factor : Serious") ) ;
 } else {
  if("yes" >< integrist)
  {
  if (" 403 " >< l) {
	if(" is disabled " >< l)exit(0);
   security_warning(port:port, protocol:"tcp",
data:string("It seems that the DELETE method is enabled on your web server\nAlthough we could not exploit this, you'd better disable it\nSolution : disable this method\nRisk factor : Medium"));
  }
  }
 }

 
 close(soc);
}

