'\" -*- tcl -*-
'\"
'\" Generated from ./modules/pop3d/pop3d_dbox.man by mpexpand with fmt.nroff
'\"
.so man.macros
.TH "pop3d::dbox" n 1.0 pop3d "Tcl POP3 Server Package"
.BS
.SH NAME
pop3d::dbox \- Simple mailbox database for pop3d
.SH "SYNOPSIS"
package require \fBTcl 8.2\fR
.sp
package require \fBpop3d::dbox ?1.0?\fR
.sp
\fB::pop3d::dbox::new\fR ?\fIdbName\fR?\fR
.sp
\fBdbName\fR \fIoption\fR ?\fIarg arg ...\fR?\fR
.sp
\fIdbName\fR \fBdestroy\fR\fR
.sp
\fIdbName\fR \fBbase\fR \fIbase\fR\fR
.sp
\fIdbName\fR \fBadd\fR \fImbox\fR\fR
.sp
\fIdbName\fR \fBremove\fR \fImbox\fR\fR
.sp
\fIdbName\fR \fBmove\fR \fIold new\fR\fR
.sp
\fIdbName\fR \fBlist\fR\fR
.sp
\fIdbName\fR \fBexists\fR \fImbox\fR\fR
.sp
\fIdbName\fR \fBlocked\fR \fImbox\fR\fR
.sp
\fIdbName\fR \fBlock\fR \fImbox\fR\fR
.sp
\fIdbName\fR \fBunlock\fR \fImbox\fR\fR
.sp
\fIdbName\fR \fBstat\fR \fImbox\fR\fR
.sp
\fIdbName\fR \fBsize\fR \fImbox msgId\fR\fR
.sp
\fIdbName\fR \fBdele\fR \fImbox msgList\fR\fR
.sp
\fIstorageCmd\fR \fBget\fR \fImbox\fR \fImsgId\fR\fR
.sp
.BE
.SH "DESCRIPTION"
.PP
The package \fBpop3d::dbox\fR provides simple/basic mailbox
management facilities. Each mailbox object manages a single base
directory whose subdirectories represent the managed mailboxes. Mails
in a mailbox are represented by files in a mailbox directory, where
each of these files contains a single mail, both headers and body, in
RFC822 conformant format.
.PP
Any mailbox object following the interface described below can be used
in conjunction with the pop3 server core provided by the package
\fBpop3d\fR. It is especially possible to directly use the objects
created by this package in the storage callback of pop3 servers
following the same interface as servers created by the package
\fBpop3d\fR.
.PP
.TP
\fB::pop3d::dbox::new\fR ?\fIdbName\fR?\fR
This command creates a new database object with an associated global
Tcl command whose name is \fIdbName\fR.
The command \fBdbName\fR may be used to invoke various operations on
the database.  It has the following general form:
.TP
\fBdbName\fR \fIoption\fR ?\fIarg arg ...\fR?\fR
\fIOption\fR and the \fIarg\fRs determine the exact behavior of the
command.
.PP
The following commands are possible for database objects:
.TP
\fIdbName\fR \fBdestroy\fR\fR
Destroys the mailbox database and all transient data. The directory
associated with the object is not destroyed.
.TP
\fIdbName\fR \fBbase\fR \fIbase\fR\fR
Defines the base directory containing the mailboxes to manage. If this
method is not called none of the following methods will work.
.TP
\fIdbName\fR \fBadd\fR \fImbox\fR\fR
Adds a mailbox of name \fImbox\fR to the database. The name must be a
valid path component.
.TP
\fIdbName\fR \fBremove\fR \fImbox\fR\fR
Removes the mailbox specified through \fImbox\fR, and the mails
contained therein, from the database. This method will fail if the
specified mailbox is locked.
.TP
\fIdbName\fR \fBmove\fR \fIold new\fR\fR
Changes the name of the mailbox \fIold\fR to \fInew\fR.
.TP
\fIdbName\fR \fBlist\fR\fR
Returns a list containing the names of all mailboxes in the directory
associated with the database.
.TP
\fIdbName\fR \fBexists\fR \fImbox\fR\fR
Returns true if the mailbox with name \fImbox\fR exists in the
database, or false if not.
.TP
\fIdbName\fR \fBlocked\fR \fImbox\fR\fR
Checks if the mailbox specified through \fImbox\fR is currently locked.
.TP
\fIdbName\fR \fBlock\fR \fImbox\fR\fR
This method locks the specified mailbox for use by a single connection
to the server. This is necessary to prevent havoc if several
connections to the same mailbox are open. The complementary method is
\fBunlock\fR. The command will return true if the lock could be set
successfully or false if not.
.TP
\fIdbName\fR \fBunlock\fR \fImbox\fR\fR
This is the complementary method to \fBlock\fR, it revokes the lock
on the specified mailbox.
.TP
\fIdbName\fR \fBstat\fR \fImbox\fR\fR
Determines the number of messages in the specified mailbox and returns
this number. This method fails if the mailbox \fImbox\fR is not
locked.
.TP
\fIdbName\fR \fBsize\fR \fImbox msgId\fR\fR
Determines the size of the message specified through its id in
\fImsgId\fR, in bytes, and returns this number.
The \fImsgId\fR has to be in the range "1 ...
[\fIdbName\fR \fBstat\fR]" or this
call will fail. If \fBstat\fR was not called
before this call, \fBsize\fR will assume
that there are zero messages in the mailbox.
.TP
\fIdbName\fR \fBdele\fR \fImbox msgList\fR\fR
Deletes the messages whose numeric ids are contained in the
\fImsgList\fR from the mailbox specified via \fImbox\fR.
The \fImsgList\fR must not be empty or this call will fail.
The numeric ids in \fImsgList\fR have to be in the range "1 ...
[\fIdbName\fR \fBstat\fR]" or this
call will fail. If \fBstat\fR was not called
before this call, \fBdele\fR will assume
that there are zero messages in the mailbox.
.TP
\fIstorageCmd\fR \fBget\fR \fImbox\fR \fImsgId\fR\fR
Returns a handle for the specified message. This handle is a mime
token following the interface described in the documentation of
package \fBmime\fR. The token is \fBread-only\fR. In other
words, the caller is allowed to do anything with the token except to
modify it.
The \fImsgId\fR has to be in the range "1 ...
[\fIdbName\fR \fBstat\fR]" or this
call will fail. If \fBstat\fR was not called
before this call, \fBget\fR will assume
that there are zero messages in the mailbox.
.SH "KEYWORDS"
pop3, internet, network, protocol, rfc1939
