# NOTE: Derived from blib/lib/Class/MethodMaker.pm.
# Changes made here will be lost when autosplit is run again.
# See AutoSplit.pm.
package Class::MethodMaker;

#line 1756 "blib/lib/Class/MethodMaker.pm (autosplit into blib/lib/auto/Class/MethodMaker/static_list.al)"
# -------------------------------------

#DOCUMENT

sub static_list {
  my ($class, @args) = @_;
  my %methods;

  foreach (@args) {
    my $field = $_;
    my @storage;

    $methods{$field} =
      sub {
        return wantarray ? @storage : \@storage;
      };


  $methods{"${field}_pop"} =
      sub {
        pop @storage;
      };

  $methods{"${field}_push"} =
      sub {
        my $class = shift;
        my @values = @_;
        push @storage, @values;
      };

  $methods{"${field}_shift"} =
      sub {
        shift @storage;
      };

  $methods{"${field}_unshift"} =
      sub {
        my $class = shift;
        my @values = @_;
        unshift @storage, @values;
      };

  $methods{"${field}_splice"} =
      sub {
        my $class = shift;
        my ($offset, $len, @list) = @_;
        splice(@storage, $offset, $len, @list);
      };

  $methods{"${field}_clear"} =
      sub {
        @storage = ();
      };

  $methods{"${field}_count"} =
      sub {
        return scalar @storage;
      };

  $methods{"${field}_index"} =
      sub {
        my $class = shift;
        my (@indices) = @_;
        my @Result;
        push @Result, $storage[$_]
          for @indices;
        return $Result[0] if @_ == 1;
        return wantarray ? @Result : \@Result;
      };

  foreach my $method_name ("${field}_set") {
    $methods{$method_name} =
      sub {
        my $class = shift;
        my @args = @_;
        croak "$method_name expects an even number of fields\n"
          if @args % 2;
        while ( my ($index, $value) = splice @args, 0, 2 ) {
          $storage[$index] = $value;
        }
        return @_ / 2;          # required for object_list
      };
  }


    #
    # Deprecated. v0.95 1.vi.00
    #
    $methods{"${field}_ref"} =
      sub {
        my ($class) = @_;
        \@storage;
      };

  }
  $class->install_methods(%methods);
}

# end of Class::MethodMaker::static_list
1;
