# NOTE: Derived from blib/lib/Class/MethodMaker.pm.
# Changes made here will be lost when autosplit is run again.
# See AutoSplit.pm.
package Class::MethodMaker;

#line 1547 "blib/lib/Class/MethodMaker.pm (autosplit into blib/lib/auto/Class/MethodMaker/key_attrib.al)"
# ----------------------------------------------------------------------


sub key_attrib {
  my ($class, @args) = @_;
  my %methods;

  foreach (@args) {
    my $field = $_;
    my %list = ();

    $methods{$field} =
      sub {
        my ($self, $new) = @_;
        if (defined $new) {
          # We need to set the value
          if (defined $self->{$field}) {
            # the object must be in the hash under its old value so
            # that entry needs to be deleted
            delete $list{$self->{$field}};
          }
          my $old;
          if ($old = $list{$new}) {
            # There's already an object stored under that value so we
            # need to unset it's value
            $old->{$field} = undef;
          }

          # Set our value to new
          $self->{$field} = $new;

          # Put ourself in the list under that value
          $list{$new} = $self;
        }
        $self->{$field};
      };

    $methods{"clear_$field"} =
      sub {
        my ($self) = @_;
        delete $list{$self->{$field}};
        $self->{$field} = undef;
      };

    $methods{"find_$field"} =
      sub {
        my ($self, @args) = @_;
        if (scalar @args) {
          return @list{@args};
        } else {
          return \%list;
        }
      };
  }
  $class->install_methods(%methods);
}

# end of Class::MethodMaker::key_attrib
1;
