/*
  libuta - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 1999  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
  
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/


#ifndef _ROOTWINDOW_H
#define _ROOTWINDOW_H

#include "widget.h"
#include "screensurface.h"
#include "mutex.h"

namespace uta {

///
class RootWindow : public Widget
{
 //these are allowed to access the access_ mutex
 friend Application;
 friend DirectSurface;

 public:
  ///
  RootWindow(int resX, int resY, int bpp, bool fullscreen);
  ///
  virtual ~RootWindow();
  /**screen content update.
     reimplements uwidgets update, display is not updated !
  */
  void update();
  ///
  virtual void create() {  dirtyRects_.push_back(globalCoord(window_));};
  ///screen update (not content)
  void updateScreen();
  ///immediate display content update
  void sync();
  ///
  void setTitle(const char*);
  ///
  virtual bool processEvent(const Event*);
  ///
  Surface* screen() { return surface_; };
  ///
  bool runDialog(Widget* );
  ///
  bool closeDialog();
  ///
  bool fullscreen() const { return fullscreen_; };
  ///
  bool doublebuffererd() const { return doublebuffered_; };

  ///force this rect to get updated to the display on next displayupdate
  void refreshRect(const Rect&);

 protected:
  ///
  list<Widget*> dialogs_;
  ///
  Surface* screen_;
  ///
  bool fullscreen_;
  ///
  bool doublebuffered_;
  ///
  Mutex access_;

};

}


#endif // !_ROOTWINDOW_H

