##Life5
#C This pattern was HACKSAW.LIF in the Hensel archive
#C Hacksaw  (orthogonal sawtooth with expansion factor 9)
#C Population is unbounded but does not tend to infinity.  Its graph is a
#C sawtooth function with ever-increasing teeth.  More specifically, the
#C population in generation t = 385*9^n - 189 (n>=1), is t/4 + 1079, but the
#C population in generation 1155*9^n - 179 (n>=0) is only 977.
#C 
#C The pattern consists of two parts, a stationary shotgun and a set
#C of puffers moving east.  The shotgun produces, and usually destroys, a salvo
#C consisting of a MWSS and 2 LWSSs.  The moving part consists of a period 8
#C blinker puffer (found by Bob Wainwright), and two p24 glider puffers, whose
#C output gliders destroy each other (with help from an accompanying MWSS).  In
#C generation 385*9^n - 189 (n>=1) (and 228 for n=0), a salvo hits the back end
#C of the row of blinkers, causing it to decay at 2c/3.  When the row is
#C completely gone, a new row starts to form and a spark is produced.  The spark
#C is turned into a glider by an accompanying HWSS; the glider is turned into a
#C westward LWSS, in generation 1155*9^n - 127 (n>=0), by interaction with the
#C glider puffers.  (This 3 glider synthesis of a LWSS is due to David
#C Buckingham.) When the LWSS hits the shotgun, in generation 2310*9^n - 184
#C (n>=0), another salvo is released, starting the cycle again.
#C 
#C The idea for this sawtooth pattern was suggested by Bill Gosper.
#C Dean Hickerson, dean@ucdmath.ucdavis.edu  7/8/92
#C Converted to structured format by ESR, January 1998
#K puffer growthlimit

## FIXME: this scene analysis is not complete.
## There are several glider guns in this pattern.

#B :mwss
#P
....*
.....*
*....*
.*****
#E

#B :fragment-1
#P
...**
***.**
.****
..**
#E

#B :blinker
#P
***
#E

#B :hwss
#P
.....*
......*
*.....*
.******
#E

#B :lwss
#P
...*
....*
*...*
.****
#E

#B :fragment-2
#P
..***
**.**
..***
#E

#B :hwss2
#P
....**
****.**
******
.****
#E

#B :lwss2
#P
.**
****
**.**
..**
#E

#B :fragment-3
#P
..*
*.*
..*
#E

#B :fragment-4
#P
**
.*
#E

#B :fragment-5
#P
...*
..**
.**
***
.**
..**
...*
#E

#B :fragment-6
#P
....*
..*.*
.*.*
*..*
.*.*
..*.*
....*
#E

#B :fragment-7
#P
....**
....*
.**
***
.**
....*
....**
#E

#B :fragment-8
#P
*
*.*
...**
...**
...**
*.*
*
#E

#B :elbow
#P
**
*
#E

#B :fragment-9
#P
.**
*..*
...*
...*
**.*
.*
#E

#B :glider2
#P
.**
**
..*
#E

#B :fragment-11
#P
*..*
....*
*...*
.****
#E

#B :fragment-12
#P
..**
.*
*
*
*
.*
..**
#E

#B :fragment-13
#P
....*
..*.*
**
**
**
..*.*
....*
#E

#B :fragment-14
#P
*
**
.**
.***
.**
**
*
#E

#B :fragment-15
#P
....**
...***
*.**
*..*
*.**
...***
....**
#E

#B :fragment-16
#P
.*
*.*
*..*
.*..*
#E

#B :fragment-17
#P
.....*
***.**...*
****....**
....**
#E

#B :fragment-18
#P
..**
.*.*
***
**
...**
..***
#E

#B :fragment-19
#P
..**
..*
*.*
**
#E

#B :fragment-20
#P
**
..*
...*
...*
...*
..*
**
#E

#B :fragment-21
#P
**
***
..**.*
..*..*
..**.*
***
**
#E

#B :eater
#P
**
.*
.*.*
..**
#E

#B :fragment-23
#P
*
****
.****
.*..*
.****
****
*
#E

#B :fragment-24
#P
...**
..*.*
.***
***
.***
..*.*
...**
#E

#B :fragment-25
#P
*.*
**
.*
#E

#B :fragment-26
#P
.**.........**
*..*.......*..*
***.........***
...*********
..*..*****..*
..**..***..**
#E

#B :fragment-27
#P
..***
.*...*
*.....*
.*...*
..***
..***
#E

#B :fragment-28
#P
..***
.**.**
.**.**
.*****
**...**
#E

#B :fragment-29
#P
...*.*
.*...*
.*
*
.*
.*...*
...*.*
#E

#B :fragment-30
#P
**
*..*
....*
....*
....*
*..*
**
#E

#B :glider
#P
.**
*.*
..*
#E

#I :mwss          82 -28 0  1 0
#I :fragment-1    82 -21 0  1 0
#I :blinker       77 -19 0  1 0
#I :hwss          79 -15 0  1 0
#I :lwss          94   8 0  1 0
#I :lwss          94  18 0 -1 0
#I :fragment-2    88  12 0  1 0
#I :blinker       84  14 0  1 0
#I :hwss2         80   5 0  1 0
#I :hwss          80  23 0 -1 0
#I :lwss2         71  17 0  1 0
#I :lwss2         71  27 0 -1 0
#I :fragment-3    67  21 0  1 0
#I :lwss          58  15 0 -1 0
#I :hwss          57  -3 0  1 0
#I :mwss          34  12 0 -1 0
#I :hwss          60  32 0 -1 0
#I :fragment-4    76  41 0  1 0
#I :fragment-5    65  39 0  1 0
#I :fragment-6    47  41 0  1 0
#I :fragment-4    44  46 0  1 0
#I :fragment-7    35  44 0  1 0
#I :fragment-8    25  42 0  1 0
#I :elbow         14  44 0  1 0
#I :fragment-9    35  26 0  1 0
#I :fragment-4    36  35 0 -1 0
#I :elbow         37  41 0 -1 0
#I :glider2       48  32 0  1 0
#I :fragment-11   52  32 0  1 0
#I :fragment-4    17  25 0  1 0
#I :fragment-12    7  23 0  1 0
#I :fragment-13  -11  25 0  1 0
#I :fragment-14  -22  22 0  1 0
#I :fragment-15  -38  20 0  1 0
#I :elbow        -45  22 0  1 0
#I :fragment-4    -6  22 0 -1 0
#I :elbow         -5   8 0 -1 0
#I :fragment-16   -6  10 0  1 0
#I :elbow         -5  16 0 -1 0
#I :fragment-17  -13 -11 0  1 0
#I :fragment-18  -19  -6 0  1 0
#I :fragment-4   -17   3 0 -1 0
#I :fragment-4   -21  10 0 -1 0
#I :fragment-6   -36   7 0  1 0
#I :elbow        -40  10 0  1 0
#I :fragment-5   -46   5 0  1 0
#I :elbow        -55   7 0  1 0
#I :fragment-19   15 -33 0  1 0
#I :fragment-4    14 -43 0 -1 0
#I :fragment-20    2 -47 0  1 0
#I :elbow         -1 -45 0 -1 0
#I :fragment-8    -9 -49 0  1 0
#I :fragment-5   -25 -46 0  1 0
#I :elbow        -26 -37 0  1 0
#I :fragment-21  -39 -44 0  1 0
#I :eater        -48 -46 0  1 0
#I :fragment-19  -45 -34 0 -1 0
#I :fragment-23  -53 -42 0  1 0
#I :fragment-24  -69 -44 0  1 0
#I :elbow        -77 -42 0  1 0
#I :fragment-25  -61 -40 0  1 0
#I :fragment-26  -61 -33 0  1 0
#I :fragment-4   -83 -51 0  1 0
#I :fragment-27  -86 -40 0  1 0
#I :fragment-28  -88 -30 0  1 0
#I :elbow        -100 -11 0  1 0
#I :fragment-29  -94 -13 0  1 0
#I :fragment-30  -77 -11 0  1 0
#I :fragment-4   -66  -8 0 -1 0
#I :elbow        -85 -16 0 -1 0
#I :glider       -83 -11 0  1 0
#I :fragment-4   -24 -13 0  1 0
#I :fragment-24  -36 -15 0  1 0
#I :fragment-23  -48 -13 0  1 0
#I :elbow        -58  -9 0 -1 0
#I :elbow        -35  -6 0  1 0
#I :mwss         -44 -23 0  1 0
#I :lwss         -57 -25 0  1 0

## Pattern ends here.
