import chart_object
import object_set
import types
import theme
import pychart_util
import color_doc

blackify_colors = 1

class T(chart_object.T):
    __doc__ = color_doc.doc
    keys={
        "r" : (pychart_util.NumType, 0, 0.0, "The intensity of red. The value is between 0 and 1."),
        "g" : (pychart_util.NumType, 0, 0.0, "The intensity of green. The value is between 0 and 1."),
        "b" : (pychart_util.NumType, 0, 0.0, "The intensity of blue. The value is between 0 and 1.")
        }
    def __str__(self):
        s = name_table().lookup(self)
        if s:
            return s
        if self.r == self.g and self.r == self.b:
            return "<color:grayscale=%f>" % self.r
        else:
            return "<color:r=%f,g=%f,b=%f>" % (self.r, self.g, self.b)
        
standards = object_set.T()
def __intern(r,g,b):
    c = T(r = r, g = g, b = b)
    standards.add(c)
    return c

def gray_scale(g):
    """Generate a grayscale color.T object. G=0 produces white, G=1.0
    produces black."""
    return T(r=g,g=g,b=g)

# generated automatically from rgb.txt

snow = __intern(r=1.000000,g=0.980392,b=0.980392)
ghostwhite = __intern(r=0.972549,g=0.972549,b=1.000000)
whitesmoke = __intern(r=0.960784,g=0.960784,b=0.960784)
gainsboro = __intern(r=0.862745,g=0.862745,b=0.862745)
floralwhite = __intern(r=1.000000,g=0.980392,b=0.941176)
oldlace = __intern(r=0.992157,g=0.960784,b=0.901961)
linen = __intern(r=0.980392,g=0.941176,b=0.901961)
antiquewhite = __intern(r=0.980392,g=0.921569,b=0.843137)
papayawhip = __intern(r=1.000000,g=0.937255,b=0.835294)
blanchedalmond = __intern(r=1.000000,g=0.921569,b=0.803922)
bisque = __intern(r=1.000000,g=0.894118,b=0.768627)
peachpuff = __intern(r=1.000000,g=0.854902,b=0.725490)
navajowhite = __intern(r=1.000000,g=0.870588,b=0.678431)
moccasin = __intern(r=1.000000,g=0.894118,b=0.709804)
cornsilk = __intern(r=1.000000,g=0.972549,b=0.862745)
ivory = __intern(r=1.000000,g=1.000000,b=0.941176)
lemonchiffon = __intern(r=1.000000,g=0.980392,b=0.803922)
seashell = __intern(r=1.000000,g=0.960784,b=0.933333)
honeydew = __intern(r=0.941176,g=1.000000,b=0.941176)
mintcream = __intern(r=0.960784,g=1.000000,b=0.980392)
azure = __intern(r=0.941176,g=1.000000,b=1.000000)
aliceblue = __intern(r=0.941176,g=0.972549,b=1.000000)
lavender = __intern(r=0.901961,g=0.901961,b=0.980392)
lavenderblush = __intern(r=1.000000,g=0.941176,b=0.960784)
mistyrose = __intern(r=1.000000,g=0.894118,b=0.882353)
white = __intern(r=1.000000,g=1.000000,b=1.000000)
black = __intern(r=0.000000,g=0.000000,b=0.000000)
darkslategray = __intern(r=0.184314,g=0.309804,b=0.309804)
dimgray = __intern(r=0.411765,g=0.411765,b=0.411765)
slategray = __intern(r=0.439216,g=0.501961,b=0.564706)
lightslategray = __intern(r=0.466667,g=0.533333,b=0.600000)
gray = __intern(r=0.745098,g=0.745098,b=0.745098)
lightgray = __intern(r=0.827451,g=0.827451,b=0.827451)
midnightblue = __intern(r=0.098039,g=0.098039,b=0.439216)
navy = __intern(r=0.000000,g=0.000000,b=0.501961)
navyblue = __intern(r=0.000000,g=0.000000,b=0.501961)
cornflowerblue = __intern(r=0.392157,g=0.584314,b=0.929412)
darkslateblue = __intern(r=0.282353,g=0.239216,b=0.545098)
slateblue = __intern(r=0.415686,g=0.352941,b=0.803922)
mediumslateblue = __intern(r=0.482353,g=0.407843,b=0.933333)
lightslateblue = __intern(r=0.517647,g=0.439216,b=1.000000)
mediumblue = __intern(r=0.000000,g=0.000000,b=0.803922)
royalblue = __intern(r=0.254902,g=0.411765,b=0.882353)
blue = __intern(r=0.000000,g=0.000000,b=1.000000)
dodgerblue = __intern(r=0.117647,g=0.564706,b=1.000000)
deepskyblue = __intern(r=0.000000,g=0.749020,b=1.000000)
skyblue = __intern(r=0.529412,g=0.807843,b=0.921569)
lightskyblue = __intern(r=0.529412,g=0.807843,b=0.980392)
steelblue = __intern(r=0.274510,g=0.509804,b=0.705882)
lightsteelblue = __intern(r=0.690196,g=0.768627,b=0.870588)
lightblue = __intern(r=0.678431,g=0.847059,b=0.901961)
powderblue = __intern(r=0.690196,g=0.878431,b=0.901961)
paleturquoise = __intern(r=0.686275,g=0.933333,b=0.933333)
darkturquoise = __intern(r=0.000000,g=0.807843,b=0.819608)
mediumturquoise = __intern(r=0.282353,g=0.819608,b=0.800000)
turquoise = __intern(r=0.250980,g=0.878431,b=0.815686)
cyan = __intern(r=0.000000,g=1.000000,b=1.000000)
lightcyan = __intern(r=0.878431,g=1.000000,b=1.000000)
cadetblue = __intern(r=0.372549,g=0.619608,b=0.627451)
mediumaquamarine = __intern(r=0.400000,g=0.803922,b=0.666667)
aquamarine = __intern(r=0.498039,g=1.000000,b=0.831373)
darkgreen = __intern(r=0.000000,g=0.392157,b=0.000000)
darkolivegreen = __intern(r=0.333333,g=0.419608,b=0.184314)
darkseagreen = __intern(r=0.560784,g=0.737255,b=0.560784)
seagreen = __intern(r=0.180392,g=0.545098,b=0.341176)
mediumseagreen = __intern(r=0.235294,g=0.701961,b=0.443137)
lightseagreen = __intern(r=0.125490,g=0.698039,b=0.666667)
palegreen = __intern(r=0.596078,g=0.984314,b=0.596078)
springgreen = __intern(r=0.000000,g=1.000000,b=0.498039)
lawngreen = __intern(r=0.486275,g=0.988235,b=0.000000)
green = __intern(r=0.000000,g=1.000000,b=0.000000)
chartreuse = __intern(r=0.498039,g=1.000000,b=0.000000)
mediumspringgreen = __intern(r=0.000000,g=0.980392,b=0.603922)
greenyellow = __intern(r=0.678431,g=1.000000,b=0.184314)
limegreen = __intern(r=0.196078,g=0.803922,b=0.196078)
yellowgreen = __intern(r=0.603922,g=0.803922,b=0.196078)
forestgreen = __intern(r=0.133333,g=0.545098,b=0.133333)
olivedrab = __intern(r=0.419608,g=0.556863,b=0.137255)
darkkhaki = __intern(r=0.741176,g=0.717647,b=0.419608)
khaki = __intern(r=0.941176,g=0.901961,b=0.549020)
palegoldenrod = __intern(r=0.933333,g=0.909804,b=0.666667)
lightgoldenrodyellow = __intern(r=0.980392,g=0.980392,b=0.823529)
lightyellow = __intern(r=1.000000,g=1.000000,b=0.878431)
yellow = __intern(r=1.000000,g=1.000000,b=0.000000)
gold = __intern(r=1.000000,g=0.843137,b=0.000000)
lightgoldenrod = __intern(r=0.933333,g=0.866667,b=0.509804)
goldenrod = __intern(r=0.854902,g=0.647059,b=0.125490)
darkgoldenrod = __intern(r=0.721569,g=0.525490,b=0.043137)
rosybrown = __intern(r=0.737255,g=0.560784,b=0.560784)
indianred = __intern(r=0.803922,g=0.360784,b=0.360784)
saddlebrown = __intern(r=0.545098,g=0.270588,b=0.074510)
sienna = __intern(r=0.627451,g=0.321569,b=0.176471)
peru = __intern(r=0.803922,g=0.521569,b=0.247059)
burlywood = __intern(r=0.870588,g=0.721569,b=0.529412)
beige = __intern(r=0.960784,g=0.960784,b=0.862745)
wheat = __intern(r=0.960784,g=0.870588,b=0.701961)
sandybrown = __intern(r=0.956863,g=0.643137,b=0.376471)
tan = __intern(r=0.823529,g=0.705882,b=0.549020)
chocolate = __intern(r=0.823529,g=0.411765,b=0.117647)
firebrick = __intern(r=0.698039,g=0.133333,b=0.133333)
brown = __intern(r=0.647059,g=0.164706,b=0.164706)
darksalmon = __intern(r=0.913725,g=0.588235,b=0.478431)
salmon = __intern(r=0.980392,g=0.501961,b=0.447059)
lightsalmon = __intern(r=1.000000,g=0.627451,b=0.478431)
orange = __intern(r=1.000000,g=0.647059,b=0.000000)
darkorange = __intern(r=1.000000,g=0.549020,b=0.000000)
coral = __intern(r=1.000000,g=0.498039,b=0.313725)
lightcoral = __intern(r=0.941176,g=0.501961,b=0.501961)
tomato = __intern(r=1.000000,g=0.388235,b=0.278431)
orangered = __intern(r=1.000000,g=0.270588,b=0.000000)
red = __intern(r=1.000000,g=0.000000,b=0.000000)
hotpink = __intern(r=1.000000,g=0.411765,b=0.705882)
deeppink = __intern(r=1.000000,g=0.078431,b=0.576471)
pink = __intern(r=1.000000,g=0.752941,b=0.796078)
lightpink = __intern(r=1.000000,g=0.713725,b=0.756863)
palevioletred = __intern(r=0.858824,g=0.439216,b=0.576471)
maroon = __intern(r=0.690196,g=0.188235,b=0.376471)
mediumvioletred = __intern(r=0.780392,g=0.082353,b=0.521569)
violetred = __intern(r=0.815686,g=0.125490,b=0.564706)
magenta = __intern(r=1.000000,g=0.000000,b=1.000000)
violet = __intern(r=0.933333,g=0.509804,b=0.933333)
plum = __intern(r=0.866667,g=0.627451,b=0.866667)
orchid = __intern(r=0.854902,g=0.439216,b=0.839216)
mediumorchid = __intern(r=0.729412,g=0.333333,b=0.827451)
darkorchid = __intern(r=0.600000,g=0.196078,b=0.800000)
darkviolet = __intern(r=0.580392,g=0.000000,b=0.827451)
blueviolet = __intern(r=0.541176,g=0.168627,b=0.886275)
purple = __intern(r=0.627451,g=0.125490,b=0.941176)
mediumpurple = __intern(r=0.576471,g=0.439216,b=0.858824)
thistle = __intern(r=0.847059,g=0.749020,b=0.847059)
snow1 = __intern(r=1.000000,g=0.980392,b=0.980392)
snow2 = __intern(r=0.933333,g=0.913725,b=0.913725)
snow3 = __intern(r=0.803922,g=0.788235,b=0.788235)
snow4 = __intern(r=0.545098,g=0.537255,b=0.537255)
seashell1 = __intern(r=1.000000,g=0.960784,b=0.933333)
seashell2 = __intern(r=0.933333,g=0.898039,b=0.870588)
seashell3 = __intern(r=0.803922,g=0.772549,b=0.749020)
seashell4 = __intern(r=0.545098,g=0.525490,b=0.509804)
antiquewhite1 = __intern(r=1.000000,g=0.937255,b=0.858824)
antiquewhite2 = __intern(r=0.933333,g=0.874510,b=0.800000)
antiquewhite3 = __intern(r=0.803922,g=0.752941,b=0.690196)
antiquewhite4 = __intern(r=0.545098,g=0.513725,b=0.470588)
bisque1 = __intern(r=1.000000,g=0.894118,b=0.768627)
bisque2 = __intern(r=0.933333,g=0.835294,b=0.717647)
bisque3 = __intern(r=0.803922,g=0.717647,b=0.619608)
bisque4 = __intern(r=0.545098,g=0.490196,b=0.419608)
peachpuff1 = __intern(r=1.000000,g=0.854902,b=0.725490)
peachpuff2 = __intern(r=0.933333,g=0.796078,b=0.678431)
peachpuff3 = __intern(r=0.803922,g=0.686275,b=0.584314)
peachpuff4 = __intern(r=0.545098,g=0.466667,b=0.396078)
navajowhite1 = __intern(r=1.000000,g=0.870588,b=0.678431)
navajowhite2 = __intern(r=0.933333,g=0.811765,b=0.631373)
navajowhite3 = __intern(r=0.803922,g=0.701961,b=0.545098)
navajowhite4 = __intern(r=0.545098,g=0.474510,b=0.368627)
lemonchiffon1 = __intern(r=1.000000,g=0.980392,b=0.803922)
lemonchiffon2 = __intern(r=0.933333,g=0.913725,b=0.749020)
lemonchiffon3 = __intern(r=0.803922,g=0.788235,b=0.647059)
lemonchiffon4 = __intern(r=0.545098,g=0.537255,b=0.439216)
cornsilk1 = __intern(r=1.000000,g=0.972549,b=0.862745)
cornsilk2 = __intern(r=0.933333,g=0.909804,b=0.803922)
cornsilk3 = __intern(r=0.803922,g=0.784314,b=0.694118)
cornsilk4 = __intern(r=0.545098,g=0.533333,b=0.470588)
ivory1 = __intern(r=1.000000,g=1.000000,b=0.941176)
ivory2 = __intern(r=0.933333,g=0.933333,b=0.878431)
ivory3 = __intern(r=0.803922,g=0.803922,b=0.756863)
ivory4 = __intern(r=0.545098,g=0.545098,b=0.513725)
honeydew1 = __intern(r=0.941176,g=1.000000,b=0.941176)
honeydew2 = __intern(r=0.878431,g=0.933333,b=0.878431)
honeydew3 = __intern(r=0.756863,g=0.803922,b=0.756863)
honeydew4 = __intern(r=0.513725,g=0.545098,b=0.513725)
lavenderblush1 = __intern(r=1.000000,g=0.941176,b=0.960784)
lavenderblush2 = __intern(r=0.933333,g=0.878431,b=0.898039)
lavenderblush3 = __intern(r=0.803922,g=0.756863,b=0.772549)
lavenderblush4 = __intern(r=0.545098,g=0.513725,b=0.525490)
mistyrose1 = __intern(r=1.000000,g=0.894118,b=0.882353)
mistyrose2 = __intern(r=0.933333,g=0.835294,b=0.823529)
mistyrose3 = __intern(r=0.803922,g=0.717647,b=0.709804)
mistyrose4 = __intern(r=0.545098,g=0.490196,b=0.482353)
azure1 = __intern(r=0.941176,g=1.000000,b=1.000000)
azure2 = __intern(r=0.878431,g=0.933333,b=0.933333)
azure3 = __intern(r=0.756863,g=0.803922,b=0.803922)
azure4 = __intern(r=0.513725,g=0.545098,b=0.545098)
slateblue1 = __intern(r=0.513725,g=0.435294,b=1.000000)
slateblue2 = __intern(r=0.478431,g=0.403922,b=0.933333)
slateblue3 = __intern(r=0.411765,g=0.349020,b=0.803922)
slateblue4 = __intern(r=0.278431,g=0.235294,b=0.545098)
royalblue1 = __intern(r=0.282353,g=0.462745,b=1.000000)
royalblue2 = __intern(r=0.262745,g=0.431373,b=0.933333)
royalblue3 = __intern(r=0.227451,g=0.372549,b=0.803922)
royalblue4 = __intern(r=0.152941,g=0.250980,b=0.545098)
blue1 = __intern(r=0.000000,g=0.000000,b=1.000000)
blue2 = __intern(r=0.000000,g=0.000000,b=0.933333)
blue3 = __intern(r=0.000000,g=0.000000,b=0.803922)
blue4 = __intern(r=0.000000,g=0.000000,b=0.545098)
dodgerblue1 = __intern(r=0.117647,g=0.564706,b=1.000000)
dodgerblue2 = __intern(r=0.109804,g=0.525490,b=0.933333)
dodgerblue3 = __intern(r=0.094118,g=0.454902,b=0.803922)
dodgerblue4 = __intern(r=0.062745,g=0.305882,b=0.545098)
steelblue1 = __intern(r=0.388235,g=0.721569,b=1.000000)
steelblue2 = __intern(r=0.360784,g=0.674510,b=0.933333)
steelblue3 = __intern(r=0.309804,g=0.580392,b=0.803922)
steelblue4 = __intern(r=0.211765,g=0.392157,b=0.545098)
deepskyblue1 = __intern(r=0.000000,g=0.749020,b=1.000000)
deepskyblue2 = __intern(r=0.000000,g=0.698039,b=0.933333)
deepskyblue3 = __intern(r=0.000000,g=0.603922,b=0.803922)
deepskyblue4 = __intern(r=0.000000,g=0.407843,b=0.545098)
skyblue1 = __intern(r=0.529412,g=0.807843,b=1.000000)
skyblue2 = __intern(r=0.494118,g=0.752941,b=0.933333)
skyblue3 = __intern(r=0.423529,g=0.650980,b=0.803922)
skyblue4 = __intern(r=0.290196,g=0.439216,b=0.545098)
lightskyblue1 = __intern(r=0.690196,g=0.886275,b=1.000000)
lightskyblue2 = __intern(r=0.643137,g=0.827451,b=0.933333)
lightskyblue3 = __intern(r=0.552941,g=0.713725,b=0.803922)
lightskyblue4 = __intern(r=0.376471,g=0.482353,b=0.545098)
slategray1 = __intern(r=0.776471,g=0.886275,b=1.000000)
slategray2 = __intern(r=0.725490,g=0.827451,b=0.933333)
slategray3 = __intern(r=0.623529,g=0.713725,b=0.803922)
slategray4 = __intern(r=0.423529,g=0.482353,b=0.545098)
lightsteelblue1 = __intern(r=0.792157,g=0.882353,b=1.000000)
lightsteelblue2 = __intern(r=0.737255,g=0.823529,b=0.933333)
lightsteelblue3 = __intern(r=0.635294,g=0.709804,b=0.803922)
lightsteelblue4 = __intern(r=0.431373,g=0.482353,b=0.545098)
lightblue1 = __intern(r=0.749020,g=0.937255,b=1.000000)
lightblue2 = __intern(r=0.698039,g=0.874510,b=0.933333)
lightblue3 = __intern(r=0.603922,g=0.752941,b=0.803922)
lightblue4 = __intern(r=0.407843,g=0.513725,b=0.545098)
lightcyan1 = __intern(r=0.878431,g=1.000000,b=1.000000)
lightcyan2 = __intern(r=0.819608,g=0.933333,b=0.933333)
lightcyan3 = __intern(r=0.705882,g=0.803922,b=0.803922)
lightcyan4 = __intern(r=0.478431,g=0.545098,b=0.545098)
paleturquoise1 = __intern(r=0.733333,g=1.000000,b=1.000000)
paleturquoise2 = __intern(r=0.682353,g=0.933333,b=0.933333)
paleturquoise3 = __intern(r=0.588235,g=0.803922,b=0.803922)
paleturquoise4 = __intern(r=0.400000,g=0.545098,b=0.545098)
cadetblue1 = __intern(r=0.596078,g=0.960784,b=1.000000)
cadetblue2 = __intern(r=0.556863,g=0.898039,b=0.933333)
cadetblue3 = __intern(r=0.478431,g=0.772549,b=0.803922)
cadetblue4 = __intern(r=0.325490,g=0.525490,b=0.545098)
turquoise1 = __intern(r=0.000000,g=0.960784,b=1.000000)
turquoise2 = __intern(r=0.000000,g=0.898039,b=0.933333)
turquoise3 = __intern(r=0.000000,g=0.772549,b=0.803922)
turquoise4 = __intern(r=0.000000,g=0.525490,b=0.545098)
cyan1 = __intern(r=0.000000,g=1.000000,b=1.000000)
cyan2 = __intern(r=0.000000,g=0.933333,b=0.933333)
cyan3 = __intern(r=0.000000,g=0.803922,b=0.803922)
cyan4 = __intern(r=0.000000,g=0.545098,b=0.545098)
darkslategray1 = __intern(r=0.592157,g=1.000000,b=1.000000)
darkslategray2 = __intern(r=0.552941,g=0.933333,b=0.933333)
darkslategray3 = __intern(r=0.474510,g=0.803922,b=0.803922)
darkslategray4 = __intern(r=0.321569,g=0.545098,b=0.545098)
aquamarine1 = __intern(r=0.498039,g=1.000000,b=0.831373)
aquamarine2 = __intern(r=0.462745,g=0.933333,b=0.776471)
aquamarine3 = __intern(r=0.400000,g=0.803922,b=0.666667)
aquamarine4 = __intern(r=0.270588,g=0.545098,b=0.454902)
darkseagreen1 = __intern(r=0.756863,g=1.000000,b=0.756863)
darkseagreen2 = __intern(r=0.705882,g=0.933333,b=0.705882)
darkseagreen3 = __intern(r=0.607843,g=0.803922,b=0.607843)
darkseagreen4 = __intern(r=0.411765,g=0.545098,b=0.411765)
seagreen1 = __intern(r=0.329412,g=1.000000,b=0.623529)
seagreen2 = __intern(r=0.305882,g=0.933333,b=0.580392)
seagreen3 = __intern(r=0.262745,g=0.803922,b=0.501961)
seagreen4 = __intern(r=0.180392,g=0.545098,b=0.341176)
palegreen1 = __intern(r=0.603922,g=1.000000,b=0.603922)
palegreen2 = __intern(r=0.564706,g=0.933333,b=0.564706)
palegreen3 = __intern(r=0.486275,g=0.803922,b=0.486275)
palegreen4 = __intern(r=0.329412,g=0.545098,b=0.329412)
springgreen1 = __intern(r=0.000000,g=1.000000,b=0.498039)
springgreen2 = __intern(r=0.000000,g=0.933333,b=0.462745)
springgreen3 = __intern(r=0.000000,g=0.803922,b=0.400000)
springgreen4 = __intern(r=0.000000,g=0.545098,b=0.270588)
green1 = __intern(r=0.000000,g=1.000000,b=0.000000)
green2 = __intern(r=0.000000,g=0.933333,b=0.000000)
green3 = __intern(r=0.000000,g=0.803922,b=0.000000)
green4 = __intern(r=0.000000,g=0.545098,b=0.000000)
chartreuse1 = __intern(r=0.498039,g=1.000000,b=0.000000)
chartreuse2 = __intern(r=0.462745,g=0.933333,b=0.000000)
chartreuse3 = __intern(r=0.400000,g=0.803922,b=0.000000)
chartreuse4 = __intern(r=0.270588,g=0.545098,b=0.000000)
olivedrab1 = __intern(r=0.752941,g=1.000000,b=0.243137)
olivedrab2 = __intern(r=0.701961,g=0.933333,b=0.227451)
olivedrab3 = __intern(r=0.603922,g=0.803922,b=0.196078)
olivedrab4 = __intern(r=0.411765,g=0.545098,b=0.133333)
darkolivegreen1 = __intern(r=0.792157,g=1.000000,b=0.439216)
darkolivegreen2 = __intern(r=0.737255,g=0.933333,b=0.407843)
darkolivegreen3 = __intern(r=0.635294,g=0.803922,b=0.352941)
darkolivegreen4 = __intern(r=0.431373,g=0.545098,b=0.239216)
khaki1 = __intern(r=1.000000,g=0.964706,b=0.560784)
khaki2 = __intern(r=0.933333,g=0.901961,b=0.521569)
khaki3 = __intern(r=0.803922,g=0.776471,b=0.450980)
khaki4 = __intern(r=0.545098,g=0.525490,b=0.305882)
lightgoldenrod1 = __intern(r=1.000000,g=0.925490,b=0.545098)
lightgoldenrod2 = __intern(r=0.933333,g=0.862745,b=0.509804)
lightgoldenrod3 = __intern(r=0.803922,g=0.745098,b=0.439216)
lightgoldenrod4 = __intern(r=0.545098,g=0.505882,b=0.298039)
lightyellow1 = __intern(r=1.000000,g=1.000000,b=0.878431)
lightyellow2 = __intern(r=0.933333,g=0.933333,b=0.819608)
lightyellow3 = __intern(r=0.803922,g=0.803922,b=0.705882)
lightyellow4 = __intern(r=0.545098,g=0.545098,b=0.478431)
yellow1 = __intern(r=1.000000,g=1.000000,b=0.000000)
yellow2 = __intern(r=0.933333,g=0.933333,b=0.000000)
yellow3 = __intern(r=0.803922,g=0.803922,b=0.000000)
yellow4 = __intern(r=0.545098,g=0.545098,b=0.000000)
gold1 = __intern(r=1.000000,g=0.843137,b=0.000000)
gold2 = __intern(r=0.933333,g=0.788235,b=0.000000)
gold3 = __intern(r=0.803922,g=0.678431,b=0.000000)
gold4 = __intern(r=0.545098,g=0.458824,b=0.000000)
goldenrod1 = __intern(r=1.000000,g=0.756863,b=0.145098)
goldenrod2 = __intern(r=0.933333,g=0.705882,b=0.133333)
goldenrod3 = __intern(r=0.803922,g=0.607843,b=0.113725)
goldenrod4 = __intern(r=0.545098,g=0.411765,b=0.078431)
darkgoldenrod1 = __intern(r=1.000000,g=0.725490,b=0.058824)
darkgoldenrod2 = __intern(r=0.933333,g=0.678431,b=0.054902)
darkgoldenrod3 = __intern(r=0.803922,g=0.584314,b=0.047059)
darkgoldenrod4 = __intern(r=0.545098,g=0.396078,b=0.031373)
rosybrown1 = __intern(r=1.000000,g=0.756863,b=0.756863)
rosybrown2 = __intern(r=0.933333,g=0.705882,b=0.705882)
rosybrown3 = __intern(r=0.803922,g=0.607843,b=0.607843)
rosybrown4 = __intern(r=0.545098,g=0.411765,b=0.411765)
indianred1 = __intern(r=1.000000,g=0.415686,b=0.415686)
indianred2 = __intern(r=0.933333,g=0.388235,b=0.388235)
indianred3 = __intern(r=0.803922,g=0.333333,b=0.333333)
indianred4 = __intern(r=0.545098,g=0.227451,b=0.227451)
sienna1 = __intern(r=1.000000,g=0.509804,b=0.278431)
sienna2 = __intern(r=0.933333,g=0.474510,b=0.258824)
sienna3 = __intern(r=0.803922,g=0.407843,b=0.223529)
sienna4 = __intern(r=0.545098,g=0.278431,b=0.149020)
burlywood1 = __intern(r=1.000000,g=0.827451,b=0.607843)
burlywood2 = __intern(r=0.933333,g=0.772549,b=0.568627)
burlywood3 = __intern(r=0.803922,g=0.666667,b=0.490196)
burlywood4 = __intern(r=0.545098,g=0.450980,b=0.333333)
wheat1 = __intern(r=1.000000,g=0.905882,b=0.729412)
wheat2 = __intern(r=0.933333,g=0.847059,b=0.682353)
wheat3 = __intern(r=0.803922,g=0.729412,b=0.588235)
wheat4 = __intern(r=0.545098,g=0.494118,b=0.400000)
tan1 = __intern(r=1.000000,g=0.647059,b=0.309804)
tan2 = __intern(r=0.933333,g=0.603922,b=0.286275)
tan3 = __intern(r=0.803922,g=0.521569,b=0.247059)
tan4 = __intern(r=0.545098,g=0.352941,b=0.168627)
chocolate1 = __intern(r=1.000000,g=0.498039,b=0.141176)
chocolate2 = __intern(r=0.933333,g=0.462745,b=0.129412)
chocolate3 = __intern(r=0.803922,g=0.400000,b=0.113725)
chocolate4 = __intern(r=0.545098,g=0.270588,b=0.074510)
firebrick1 = __intern(r=1.000000,g=0.188235,b=0.188235)
firebrick2 = __intern(r=0.933333,g=0.172549,b=0.172549)
firebrick3 = __intern(r=0.803922,g=0.149020,b=0.149020)
firebrick4 = __intern(r=0.545098,g=0.101961,b=0.101961)
brown1 = __intern(r=1.000000,g=0.250980,b=0.250980)
brown2 = __intern(r=0.933333,g=0.231373,b=0.231373)
brown3 = __intern(r=0.803922,g=0.200000,b=0.200000)
brown4 = __intern(r=0.545098,g=0.137255,b=0.137255)
salmon1 = __intern(r=1.000000,g=0.549020,b=0.411765)
salmon2 = __intern(r=0.933333,g=0.509804,b=0.384314)
salmon3 = __intern(r=0.803922,g=0.439216,b=0.329412)
salmon4 = __intern(r=0.545098,g=0.298039,b=0.223529)
lightsalmon1 = __intern(r=1.000000,g=0.627451,b=0.478431)
lightsalmon2 = __intern(r=0.933333,g=0.584314,b=0.447059)
lightsalmon3 = __intern(r=0.803922,g=0.505882,b=0.384314)
lightsalmon4 = __intern(r=0.545098,g=0.341176,b=0.258824)
orange1 = __intern(r=1.000000,g=0.647059,b=0.000000)
orange2 = __intern(r=0.933333,g=0.603922,b=0.000000)
orange3 = __intern(r=0.803922,g=0.521569,b=0.000000)
orange4 = __intern(r=0.545098,g=0.352941,b=0.000000)
darkorange1 = __intern(r=1.000000,g=0.498039,b=0.000000)
darkorange2 = __intern(r=0.933333,g=0.462745,b=0.000000)
darkorange3 = __intern(r=0.803922,g=0.400000,b=0.000000)
darkorange4 = __intern(r=0.545098,g=0.270588,b=0.000000)
coral1 = __intern(r=1.000000,g=0.447059,b=0.337255)
coral2 = __intern(r=0.933333,g=0.415686,b=0.313725)
coral3 = __intern(r=0.803922,g=0.356863,b=0.270588)
coral4 = __intern(r=0.545098,g=0.243137,b=0.184314)
tomato1 = __intern(r=1.000000,g=0.388235,b=0.278431)
tomato2 = __intern(r=0.933333,g=0.360784,b=0.258824)
tomato3 = __intern(r=0.803922,g=0.309804,b=0.223529)
tomato4 = __intern(r=0.545098,g=0.211765,b=0.149020)
orangered1 = __intern(r=1.000000,g=0.270588,b=0.000000)
orangered2 = __intern(r=0.933333,g=0.250980,b=0.000000)
orangered3 = __intern(r=0.803922,g=0.215686,b=0.000000)
orangered4 = __intern(r=0.545098,g=0.145098,b=0.000000)
red1 = __intern(r=1.000000,g=0.000000,b=0.000000)
red2 = __intern(r=0.933333,g=0.000000,b=0.000000)
red3 = __intern(r=0.803922,g=0.000000,b=0.000000)
red4 = __intern(r=0.545098,g=0.000000,b=0.000000)
deeppink1 = __intern(r=1.000000,g=0.078431,b=0.576471)
deeppink2 = __intern(r=0.933333,g=0.070588,b=0.537255)
deeppink3 = __intern(r=0.803922,g=0.062745,b=0.462745)
deeppink4 = __intern(r=0.545098,g=0.039216,b=0.313725)
hotpink1 = __intern(r=1.000000,g=0.431373,b=0.705882)
hotpink2 = __intern(r=0.933333,g=0.415686,b=0.654902)
hotpink3 = __intern(r=0.803922,g=0.376471,b=0.564706)
hotpink4 = __intern(r=0.545098,g=0.227451,b=0.384314)
pink1 = __intern(r=1.000000,g=0.709804,b=0.772549)
pink2 = __intern(r=0.933333,g=0.662745,b=0.721569)
pink3 = __intern(r=0.803922,g=0.568627,b=0.619608)
pink4 = __intern(r=0.545098,g=0.388235,b=0.423529)
lightpink1 = __intern(r=1.000000,g=0.682353,b=0.725490)
lightpink2 = __intern(r=0.933333,g=0.635294,b=0.678431)
lightpink3 = __intern(r=0.803922,g=0.549020,b=0.584314)
lightpink4 = __intern(r=0.545098,g=0.372549,b=0.396078)
palevioletred1 = __intern(r=1.000000,g=0.509804,b=0.670588)
palevioletred2 = __intern(r=0.933333,g=0.474510,b=0.623529)
palevioletred3 = __intern(r=0.803922,g=0.407843,b=0.537255)
palevioletred4 = __intern(r=0.545098,g=0.278431,b=0.364706)
maroon1 = __intern(r=1.000000,g=0.203922,b=0.701961)
maroon2 = __intern(r=0.933333,g=0.188235,b=0.654902)
maroon3 = __intern(r=0.803922,g=0.160784,b=0.564706)
maroon4 = __intern(r=0.545098,g=0.109804,b=0.384314)
violetred1 = __intern(r=1.000000,g=0.243137,b=0.588235)
violetred2 = __intern(r=0.933333,g=0.227451,b=0.549020)
violetred3 = __intern(r=0.803922,g=0.196078,b=0.470588)
violetred4 = __intern(r=0.545098,g=0.133333,b=0.321569)
magenta1 = __intern(r=1.000000,g=0.000000,b=1.000000)
magenta2 = __intern(r=0.933333,g=0.000000,b=0.933333)
magenta3 = __intern(r=0.803922,g=0.000000,b=0.803922)
magenta4 = __intern(r=0.545098,g=0.000000,b=0.545098)
orchid1 = __intern(r=1.000000,g=0.513725,b=0.980392)
orchid2 = __intern(r=0.933333,g=0.478431,b=0.913725)
orchid3 = __intern(r=0.803922,g=0.411765,b=0.788235)
orchid4 = __intern(r=0.545098,g=0.278431,b=0.537255)
plum1 = __intern(r=1.000000,g=0.733333,b=1.000000)
plum2 = __intern(r=0.933333,g=0.682353,b=0.933333)
plum3 = __intern(r=0.803922,g=0.588235,b=0.803922)
plum4 = __intern(r=0.545098,g=0.400000,b=0.545098)
mediumorchid1 = __intern(r=0.878431,g=0.400000,b=1.000000)
mediumorchid2 = __intern(r=0.819608,g=0.372549,b=0.933333)
mediumorchid3 = __intern(r=0.705882,g=0.321569,b=0.803922)
mediumorchid4 = __intern(r=0.478431,g=0.215686,b=0.545098)
darkorchid1 = __intern(r=0.749020,g=0.243137,b=1.000000)
darkorchid2 = __intern(r=0.698039,g=0.227451,b=0.933333)
darkorchid3 = __intern(r=0.603922,g=0.196078,b=0.803922)
darkorchid4 = __intern(r=0.407843,g=0.133333,b=0.545098)
purple1 = __intern(r=0.607843,g=0.188235,b=1.000000)
purple2 = __intern(r=0.568627,g=0.172549,b=0.933333)
purple3 = __intern(r=0.490196,g=0.149020,b=0.803922)
purple4 = __intern(r=0.333333,g=0.101961,b=0.545098)
mediumpurple1 = __intern(r=0.670588,g=0.509804,b=1.000000)
mediumpurple2 = __intern(r=0.623529,g=0.474510,b=0.933333)
mediumpurple3 = __intern(r=0.537255,g=0.407843,b=0.803922)
mediumpurple4 = __intern(r=0.364706,g=0.278431,b=0.545098)
thistle1 = __intern(r=1.000000,g=0.882353,b=1.000000)
thistle2 = __intern(r=0.933333,g=0.823529,b=0.933333)
thistle3 = __intern(r=0.803922,g=0.709804,b=0.803922)
thistle4 = __intern(r=0.545098,g=0.482353,b=0.545098)
gray00 = __intern(r=0.000000,g=0.000000,b=0.000000)
gray01 = __intern(r=0.011765,g=0.011765,b=0.011765)
gray02 = __intern(r=0.019608,g=0.019608,b=0.019608)
gray03 = __intern(r=0.031373,g=0.031373,b=0.031373)
gray04 = __intern(r=0.039216,g=0.039216,b=0.039216)
gray05 = __intern(r=0.050980,g=0.050980,b=0.050980)
gray06 = __intern(r=0.058824,g=0.058824,b=0.058824)
gray07 = __intern(r=0.070588,g=0.070588,b=0.070588)
gray08 = __intern(r=0.078431,g=0.078431,b=0.078431)
gray09 = __intern(r=0.090196,g=0.090196,b=0.090196)
gray10 = __intern(r=0.101961,g=0.101961,b=0.101961)
gray11 = __intern(r=0.109804,g=0.109804,b=0.109804)
gray12 = __intern(r=0.121569,g=0.121569,b=0.121569)
gray13 = __intern(r=0.129412,g=0.129412,b=0.129412)
gray14 = __intern(r=0.141176,g=0.141176,b=0.141176)
gray15 = __intern(r=0.149020,g=0.149020,b=0.149020)
gray16 = __intern(r=0.160784,g=0.160784,b=0.160784)
gray17 = __intern(r=0.168627,g=0.168627,b=0.168627)
gray18 = __intern(r=0.180392,g=0.180392,b=0.180392)
gray19 = __intern(r=0.188235,g=0.188235,b=0.188235)
gray20 = __intern(r=0.200000,g=0.200000,b=0.200000)
gray21 = __intern(r=0.211765,g=0.211765,b=0.211765)
gray22 = __intern(r=0.219608,g=0.219608,b=0.219608)
gray23 = __intern(r=0.231373,g=0.231373,b=0.231373)
gray24 = __intern(r=0.239216,g=0.239216,b=0.239216)
gray25 = __intern(r=0.250980,g=0.250980,b=0.250980)
gray26 = __intern(r=0.258824,g=0.258824,b=0.258824)
gray27 = __intern(r=0.270588,g=0.270588,b=0.270588)
gray28 = __intern(r=0.278431,g=0.278431,b=0.278431)
gray29 = __intern(r=0.290196,g=0.290196,b=0.290196)
gray30 = __intern(r=0.301961,g=0.301961,b=0.301961)
gray31 = __intern(r=0.309804,g=0.309804,b=0.309804)
gray32 = __intern(r=0.321569,g=0.321569,b=0.321569)
gray33 = __intern(r=0.329412,g=0.329412,b=0.329412)
gray34 = __intern(r=0.341176,g=0.341176,b=0.341176)
gray35 = __intern(r=0.349020,g=0.349020,b=0.349020)
gray36 = __intern(r=0.360784,g=0.360784,b=0.360784)
gray37 = __intern(r=0.368627,g=0.368627,b=0.368627)
gray38 = __intern(r=0.380392,g=0.380392,b=0.380392)
gray39 = __intern(r=0.388235,g=0.388235,b=0.388235)
gray40 = __intern(r=0.400000,g=0.400000,b=0.400000)
gray41 = __intern(r=0.411765,g=0.411765,b=0.411765)
gray42 = __intern(r=0.419608,g=0.419608,b=0.419608)
gray43 = __intern(r=0.431373,g=0.431373,b=0.431373)
gray44 = __intern(r=0.439216,g=0.439216,b=0.439216)
gray45 = __intern(r=0.450980,g=0.450980,b=0.450980)
gray46 = __intern(r=0.458824,g=0.458824,b=0.458824)
gray47 = __intern(r=0.470588,g=0.470588,b=0.470588)
gray48 = __intern(r=0.478431,g=0.478431,b=0.478431)
gray49 = __intern(r=0.490196,g=0.490196,b=0.490196)
gray50 = __intern(r=0.498039,g=0.498039,b=0.498039)
gray51 = __intern(r=0.509804,g=0.509804,b=0.509804)
gray52 = __intern(r=0.521569,g=0.521569,b=0.521569)
gray53 = __intern(r=0.529412,g=0.529412,b=0.529412)
gray54 = __intern(r=0.541176,g=0.541176,b=0.541176)
gray55 = __intern(r=0.549020,g=0.549020,b=0.549020)
gray56 = __intern(r=0.560784,g=0.560784,b=0.560784)
gray57 = __intern(r=0.568627,g=0.568627,b=0.568627)
gray58 = __intern(r=0.580392,g=0.580392,b=0.580392)
gray59 = __intern(r=0.588235,g=0.588235,b=0.588235)
gray60 = __intern(r=0.600000,g=0.600000,b=0.600000)
gray61 = __intern(r=0.611765,g=0.611765,b=0.611765)
gray62 = __intern(r=0.619608,g=0.619608,b=0.619608)
gray63 = __intern(r=0.631373,g=0.631373,b=0.631373)
gray64 = __intern(r=0.639216,g=0.639216,b=0.639216)
gray65 = __intern(r=0.650980,g=0.650980,b=0.650980)
gray66 = __intern(r=0.658824,g=0.658824,b=0.658824)
gray67 = __intern(r=0.670588,g=0.670588,b=0.670588)
gray68 = __intern(r=0.678431,g=0.678431,b=0.678431)
gray69 = __intern(r=0.690196,g=0.690196,b=0.690196)
gray70 = __intern(r=0.701961,g=0.701961,b=0.701961)
gray71 = __intern(r=0.709804,g=0.709804,b=0.709804)
gray72 = __intern(r=0.721569,g=0.721569,b=0.721569)
gray73 = __intern(r=0.729412,g=0.729412,b=0.729412)
gray74 = __intern(r=0.741176,g=0.741176,b=0.741176)
gray75 = __intern(r=0.749020,g=0.749020,b=0.749020)
gray76 = __intern(r=0.760784,g=0.760784,b=0.760784)
gray77 = __intern(r=0.768627,g=0.768627,b=0.768627)
gray78 = __intern(r=0.780392,g=0.780392,b=0.780392)
gray79 = __intern(r=0.788235,g=0.788235,b=0.788235)
gray80 = __intern(r=0.800000,g=0.800000,b=0.800000)
gray81 = __intern(r=0.811765,g=0.811765,b=0.811765)
gray82 = __intern(r=0.819608,g=0.819608,b=0.819608)
gray83 = __intern(r=0.831373,g=0.831373,b=0.831373)
gray84 = __intern(r=0.839216,g=0.839216,b=0.839216)
gray85 = __intern(r=0.850980,g=0.850980,b=0.850980)
gray86 = __intern(r=0.858824,g=0.858824,b=0.858824)
gray87 = __intern(r=0.870588,g=0.870588,b=0.870588)
gray88 = __intern(r=0.878431,g=0.878431,b=0.878431)
gray89 = __intern(r=0.890196,g=0.890196,b=0.890196)
gray90 = __intern(r=0.898039,g=0.898039,b=0.898039)
gray91 = __intern(r=0.909804,g=0.909804,b=0.909804)
gray92 = __intern(r=0.921569,g=0.921569,b=0.921569)
gray93 = __intern(r=0.929412,g=0.929412,b=0.929412)
gray94 = __intern(r=0.941176,g=0.941176,b=0.941176)
gray95 = __intern(r=0.949020,g=0.949020,b=0.949020)
gray96 = __intern(r=0.960784,g=0.960784,b=0.960784)
gray97 = __intern(r=0.968627,g=0.968627,b=0.968627)
gray98 = __intern(r=0.980392,g=0.980392,b=0.980392)
gray99 = __intern(r=0.988235,g=0.988235,b=0.988235)
gray100 = __intern(r=1.000000,g=1.000000,b=1.000000)
darkgray = __intern(r=0.662745,g=0.662745,b=0.662745)
darkblue = __intern(r=0.000000,g=0.000000,b=0.545098)
darkcyan = __intern(r=0.000000,g=0.545098,b=0.545098)
darkmagenta = __intern(r=0.545098,g=0.000000,b=0.545098)
darkred = __intern(r=0.545098,g=0.000000,b=0.000000)
lightgreen = __intern(r=0.564706,g=0.933333,b=0.564706)
default = black

__name_table = None
def name_table():
    global __name_table
    if not __name_table:
        __name_table = pychart_util.symbol_lookup_table(globals(), standards)
    return __name_table
