(* Copyright (C) 1995, Digital Equipment Corporation.       *)
(* All rights reserved.                                     *)
(* See the file COPYRIGHT for a full description.           *)
(*                                                          *)
(* Last modified on Thu Feb  9 08:50:12 PST 1995 by kalsow  *)
(*      modified on Sun Jun  5 21:58:07 PDT 1994 by mhb     *)
(*      modified on Wed Feb 17 16:46:35 PST 1993 by johnh   *)

(*********************************************************************
|*  NOTE: This file is generated automatically from the event 
|*        definition file Minimax.evt.
|*********************************************************************)

<* PRAGMA LL *>

INTERFACE MinimaxIE;

<*NOWARN*> IMPORT Minimax, Thread, View, TypeFmt, GameBoard;
<*NOWARN*> IMPORT Algorithm;


(* call the following to generate an event: *)

PROCEDURE Setup (
      initiator: Algorithm.T; 
        
    ) RAISES {Thread.Alerted};
    <* LL = {} *>

PROCEDURE PlayerMove (
      initiator: Algorithm.T; 
       player: INTEGER; fromx, fromy, tox, toy: INTEGER 
    ) RAISES {Thread.Alerted};
    <* LL = {} *>

PROCEDURE Finished (
      initiator: Algorithm.T; 
       winner: INTEGER 
    ) RAISES {Thread.Alerted};
    <* LL = {} *>

PROCEDURE EvaluateNode (
      initiator: Algorithm.T; 
       board: GameBoard.T 
    ) RAISES {Thread.Alerted};
    <* LL = {} *>

PROCEDURE PlayerThinking (
      initiator: Algorithm.T; 
       player: INTEGER; board: GameBoard.T 
    ) RAISES {Thread.Alerted};
    <* LL = {} *>

PROCEDURE FinishedEvalNode (
      initiator: Algorithm.T; 
       board: GameBoard.T 
    ) RAISES {Thread.Alerted};
    <* LL = {} *>

PROCEDURE BoardValueUpdated (
      initiator: Algorithm.T; 
       board: GameBoard.T; newValue: Minimax.BoardValue 
    ) RAISES {Thread.Alerted};
    <* LL = {} *>

PROCEDURE HumanCellSelected (
      initiator: Algorithm.T; 
       xCoord, yCoord: INTEGER 
    ) RAISES {Thread.Alerted};
    <* LL = {} *>

PROCEDURE HumanIllegalMove (
      initiator: Algorithm.T; 
        
    ) RAISES {Thread.Alerted};
    <* LL = {} *>

PROCEDURE HumanSelection (
      initiator: View.T; 
       xCoord, yCoord: INTEGER 
    ) RAISES {Thread.Alerted};
    <* LL = VBT.mu *>


END MinimaxIE.
