#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# Script audit and contributions from Carmichael Security <http://www.carmichaelsecurity.com>
#      Erik Anderson <eanders@carmichaelsecurity.com>
#      Added BugtraqID and CVE
#
# See the Nessus Scripts License for details
#
# This check covers CVE-2001-1234, but a similar flaw (with a different
# CVE) was found later on.
#
# Ref: http://gallery.menalto.com/modules.php?op=modload&name=News&file=article&sid=50


if(description)
{
 script_id(11115);
 script_version ("$Revision: 1.3.2.2 $");
 script_cve_id("CVE-2001-1234");
 script_bugtraq_id(3397);
 name["english"] = "gallery code injection";

 script_name(english:name["english"]);
 
 desc["english"] = "
It is possible to make the remote host include php files hosted
on a third party server using Gallery.

An attacker may use this flaw to inject arbitrary code in the remote
host and gain a shell with the privileges of the web server.

Reference : http://online.securityfocus.com/bid/3397

Solution : Upgrade to Gallery 1.3.1 or newer
Risk factor : Serious";




 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the presence of includes/needinit.php";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 
 script_copyright(english:"This script is Copyright (C) 2002 Renaud Deraison",
		francais:"Ce script est Copyright (C) 2002 Renaud Deraison");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");

port = get_kb_item("Services/www");
if(!port) port = 80;

if(!get_port_state(port))exit(0);
if(http_is_dead(port:port))exit(0);

function check(url)
{
req = http_get(item:string(url, "/errors/needinit.php?GALLERY_BASEDIR=http://xxxxxxxx/"),
 		port:port);
soc = http_open_socket(port);
if(!soc)exit(0);
send(socket:soc, data:req);
r = http_recv(socket:soc);
http_close_socket(soc);
 if("http://xxxxxxxx/errors/configure_instructions" >< r)
 	{
 	security_hole(port);
	exit(0);
	}
 
}

check(url:"");
check(url:cgibin());

