#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10284);
 script_version ("$Revision: 1.17.2.1 $");
 script_cve_id("CAN-1999-1516");
 
 name["english"] = "TFS SMTP 3.2 MAIL FROM overflow";
 name["francais"] = "Dpassement de buffer dans TFS SMTP 3.2 suite  la commande MAIL FROM";
 script_name(english:name["english"],
 	     francais:name["francais"]);
 
 desc["english"] = "
There seem to be a buffer overflow in the remote SMTP server
when the server is issued a too long argument to the 'MAIL FROM'
command.

This problem may allow an attacker to prevent this host
to act as a mail host and may even allow him to execute
arbitrary code on this system.


Solution : If you are using TFS SMTP, upgrade to version 4.0.
If you do not, then inform your vendor of this vulnerability
and wait for a patch.

Risk factor : High";


 desc["francais"] = "
Il semble y avoir un dpassement de buffer dans le
serveur SMTP distant lorsque celui-ci reoit un
argument trop long a la commande 'MAIL FROM'.

Ce problme peut permettre  un pirate d'empecher
cette machine d'agir comme un serveur de mail, et
peut meme lui permettre d'executer du code arbitraire
sur ce systme.


Solution : Si vous utilisez TFS SMTP, alors mettez-le  jour
en version 4.0. Si ce n'est pas le cas, informez votre 
vendeur de cette vulnrabilit et attendez un patch.

Facteur de risque : Elev";

 script_description(english:desc["english"],
 	 	    francais:desc["francais"]);
		    
 
 summary["english"] = "Overflows a buffer in the remote mail server"; 
 summary["francais"] = "Dpassemement de buffer dans le serveur de mail distant";
 script_summary(english:summary["english"],
 		 francais:summary["francais"]);
 
 script_category(ACT_MIXED_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison",
 		  francais:"Ce script est Copyright (C) 1999 Renaud Deraison");
 
 family["english"] = "SMTP problems";
 family["francais"] = "Problmes SMTP";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "sendmail_expn.nasl");
 script_exclude_keys("SMTP/wrapped",
 		     "SMTP/postfix",
		     "SMTP/qmail");
 script_require_ports("Services/smtp", 25);
 exit(0);
}

#
# The script code starts here
#


port = get_kb_item("Services/smtp");
if(!port)port = 25;

if(safe_checks())
{ 
 banner = get_kb_item(string("smtp/banner/", port));
 if(!banner)
 {
  if(get_port_state(port))
  {
   soc = open_sock_tcp(port);
   banner = recv_line(socket:soc, length:4096);
   close(soc);
  }
 }
 
 if(banner)
 {
  if(ereg(string:banner,
  	  pattern:"TFS SMTP Server [1-3]\..*"))
	  {
	  alrt = "
The remote TFS SMTP server is vulnerable to a buffer
overflow when issued a too long argument to the 
'MAIL FROM' command.

An attacker can use this flaw to execute arbitrary
code on this host.

*** Nessus reports this vulnerability using only
*** information that was gathered. Use caution
*** when testing without safe checks enabled.

Solution : upgrade to version 4.0
Risk factor : High";
   	  security_hole(port:port, data:alrt);
	  }
 }
 
 exit(0);
}
if(get_port_state(port))
{
 soc = open_sock_tcp(port);
 if(soc)
 {
 data = recv_line(socket:soc, length:1024);	
 crp = string("HELO nessus.org\r\n");
 send(socket:soc, data:crp);
 data = recv_line(socket:soc, length:1024);
 if("250 " >< data)
 {
 crp = string("MAIL FROM: ", crap(1024), "\r\n");
 send(socket:soc, data:crp);
 buf = recv_line(socket:soc, length:1024);
 if(!buf){
  security_hole(port);
  }
 }
 close(soc);
 }
}
