#
# This script was written by Michael Scheidell SECNAP Network Security
#
# See the Nessus Scripts License for details

if(description)
{
 script_id(11177);
 script_cve_id("CAN-2002-1183","CAN-2002-0862");

 name["english"] = "Flaw in Microsoft VM JDBC Classes Could Allow Code Execution (Q329077)";

 script_name(english:name["english"]);
 
 desc["english"] = "
Hotfix to fix Flaw in Microsoft VM JDBC Classes
could Allow Code Execution (Q329077)

Impact of vulnerability: Three vulnerabilities, the most
serious of which could enable an attacker to gain complete
control over a user's system. 

Maximum Severity Rating: Critical 

Recommendation: Administrators should install the patch immediately. 

Affected Software: 

Versions of the Microsoft virtual machine (Microsoft VM) are
identified by build numbers, which can be determined using the
JVIEW tool as discussed in the FAQ. All builds of the Microsoft
VM up to and including build 5.0.3805 are affected by these
vulnerabilities. 

See
http://www.microsoft.com/technet/security/bulletin/ms02-052.asp

Also Note: Requires full registry access (Administrator)
to run the test.

Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for MS Hotfix Q329077, Flaw in Microsoft VM JDBC";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2002 SECNAP Network Security, LLC");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("netbios_name_get.nasl",
 		     "smb_login.nasl","smb_registry_full_access.nasl",
		     "smb_reg_service_pack.nasl",
		     "smb_reg_service_pack_XP.nasl",
		     "smb_reg_service_pack_W2K.nasl");
 script_require_keys("SMB/name", "SMB/login", "SMB/password",
		     "SMB/WindowsVersion",
		     "SMB/registry_full_access");
 script_exclude_keys("SMB/samba");
 script_require_ports(139, 445);
 exit(0);
}

include("smb_nt.inc");
port = get_kb_item("SMB/transport");
if(!port)port = 139;

access = get_kb_item("SMB/registry_full_access");
if(!access)exit(0);

key = "SOFTWARE\Microsoft\Active Setup\Installed Components\{DBB3C81D-3C91-4a1e-BDDF-905B61C7CEDF}";
item = "Version";

# should be "5,00,3807,0";
 value = registry_get_sz(key:key, item:item);
if(!("5,00,3807,0" >< value))
{
   security_hole(port);
}

