#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10844);
 script_version ("$Revision: 1.3.2.1 $");
 name["english"] = "ASP.NET Cross Site Scripting";

 script_name(english:name["english"]);
 
 desc["english"] = "
ASP.NET is vulnerable to a cross site scripting vulnerability.

Solution : There was no solution ready when this vulnerability was written;
Please contact the vendor for updates that address this vulnerability.

Risk factor : Medium";

 script_description(english:desc["english"]);
 
 summary["english"] = "Tests for ASP.NET CSS";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2002 Renaud Deraison",
		francais:"Ce script est Copyright (C) 2002 Renaud Deraison");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "no404.nasl", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_require_keys("www/iis");
 exit(0);
}


include("http_func.inc");
port = get_kb_item("Services/www");
if(!port)port = 80;
if(get_port_state(port))
{ 
 str = "/~/<script>alert(document.cookie)</script>.aspx?aspxerrorpath=null";
 req= http_get(item:str, port:port);	

 soc = http_open_socket(port);
 if(soc)
 {
 send(socket:soc, data:req);
 r = http_recv(socket:soc);
 http_close_socket(soc);
 lookfor = "<script>alert(document.cookie)</script>";
 if(lookfor >< r)
  {
   security_warning(port);
  }
 }
}
