#!/usr/bin/perl

##############################################################################
# email companion script with My Calendar v1.7+
#
# This script should be run at the same time each day by something like cron 
# and then it will email you each day with the days appointments, the onces
# coming up for the next $days_to_look_ahead, and your ToDo list.  It will 
# omit any section that does not exist and will omit the email all together 
# if if finds nothing.
#
# requires: sendmail and some automated program to run it like cron
#
# by the scripting wizards at FuzzyMonkey.org (support@fuzzymonkey.org)
# copywright 2003 Michael Spiceland (GPL)
#############################################################################

#############################################################################
# Configuration - just set these few variables and your done!
# 
# A few important notes:
#
# You must use an absolute path to the $appointments_file in most cases
# because cron (and maybe other programs like it) do not pass the path
# to the script that it is running.
# 
# Leave $admin_email blank to have the output printed to STDOUT
# for most versions of cron, this will email the output to the owner of the
# cronjob.  If an emaiil is given, the program will attempt to use the
# sendmail program specified on $sendmail to send the mail out.
#############################################################################
$days_to_look_ahead = '3';
$appointments_file = '/var/www/cgi-bin/calendar/appointments.txt';
$admin_email = 'mikeanderin@fuzzymonkey.org';
$sendmail = '/usr/lib/sendmail';

#############################################################################
###### DONT EDIT BELOW THIS LINE ############################################
#############################################################################

%apps = get_appointments("$appointments_file");

# get apps
$time = time();
while($days_to_look_ahead > 0){
	$body .= get_appointment_list_for_day("$time");
	$days_to_look_ahead--;
	$time = $time + (60*60*24); # go back one day
}

# need to add ToDo stuff here whenever I implement a ToDo list

if($body){
	if($admin_email){
		email("reminders from calendar", $admin_email, $admin_email, $body);
	}else{
		print "$body\n";
	}
}

#############################################################################
# subroutines 
#############################################################################

sub get_appointment_list_for_day($){
	my $return;
	my $date = time_to_date($_[0]);
	my ($month,$day,$year) = split(/-/,$date);
	my @appointments = @{$apps{$date}};
	@appointments = (@appointments,@{$apps{"$month-$day-*"}});
	@appointments = (@appointments,@{$apps{"*-$day-*"}});
	my $appointment;
	my $today = time_to_date(time());
	my $tomorrow = time_to_date(time()+60*60*24);
	my $weekday;
	my $days_till_app = int(($_[0]-time())/(60*60*24));


	foreach $appointment (@appointments){
		$return .= "$appointment\n";
	}
	
	# only print stuff if we have something for this day!
	if($return){	
		$weekday = time_to_day_of_the_week($_[0]);
		if($date eq $today){
			$date = "today  $date";
		}elsif($date eq $tomorrow){
			$date = "tomorrow $date";
		}else{
			$date = "$weekday $date (in $days_till_app days)";
		}
		$return = "\
Appointments for $date
------------------------------
$return\n";
	}

	return $return;
}

sub time_to_day_of_the_week($){
	my $return;
	my @days = ("Sun","Mon","Tues","Wed","Thur","Fri","Sat","Sun");
	my ($sec,$min,$hr,$mday,$mon,$year,$wday,$yday,$isdst) = localtime($_[0]);

	return "$days[$wday]";
}

sub time_to_date($){
	my $return;
	my ($sec,$min,$hr,$mday,$mon,$year,$wday,$yday,$isdst) = localtime($_[0]);
	$year = $year + 1900;
	$mon = $mon + 1;

	return "$mon-$mday-$year";
}

sub get_appointments ($){
	my $app_day;
	my $app;
	my %apps;
	if (open(INFILE, "<$_[0]")){
		while(<INFILE>){
			unless(/^#/){ # ignore comments
				chomp;
				($date,$text,$id) = split(/\t/,$_);
				push(@{$apps{"$date"}},"$text");
			}
		}
		close INFILE;
	}else{
		die("Calendar reminder script could not open the appointments.txt file.  This could be an issue with cron or whatever automated script you are running not inheriting the paths and such.  This script attempts to open the appontments file in the same direcctory as this reminder script. The file the script attempted to open is $_[0].  If this is not what you were expecting then this is sureply the problem.\n\n$!");
	}

	return %apps;
}

sub email($$$$){
    my ($subject, $to, $from, $body) = @_;

    open (MAIL, "| $sendmail -i -t" ) || die("could not open mail");
    print MAIL <<MAIL_MESSAGE;
To:$to
From:$from
Subject:$subject
$body
MAIL_MESSAGE
     close MAIL;
}


