/*
  libuta - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 1999  Karsten Laux <klaux@student.uni-kl.de>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
  
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

// June 1999


#ifndef _LISTBOX_H
#define _LISTBOX_H

#include "togglebutton.h"
#include "pushbutton.h"

namespace uta {

///
class ListBox : public Widget
{
 //OBJECT

 public:
  ///
  ListBox(Widget* parent, int x, int y, int w, int h);
  ///
  virtual ~ListBox();

  ///
  void setColor(const Color& color);
  ///
  void setDisabledColor(const Color& color);
  ///
  void setDisabledAlpha(unsigned char alpha);
  ///
  void setSelectedColor(const Color& );

  ///
  string getSelection() const;
  ///
  unsigned int getSelectedID() const { return selected_; };

  ///
  void addElement(const string&);
  ///
  void addElements(const vector<string>&);
  ///
  void clear();
  ///
  void scrollUp();
  ///
  void scrollDown();
  ///
  SigC::Signal1<void, const char*> selectionChanged;
  ///
  SigC::Signal1<void, int> selection;
  
  ///select this item 
  void setSelected(int);  


  ///select an item
  void selected(int);
  ///unselect this item 
  void unselected(int);
  
  ///
  enum 
  {
    SCROLLERWIDTH = 25,
    SCROLLERHEIGHT = 25,
    ELEMENTHEIGHT = 25
  };

 protected:
  ///
  void updateList();
  ///
  PushButton* scrollUp_;
  ///
  PushButton* scrollDown_;
  ///
  vector<Button*> buttons_;
  ///
  vector<string> elements_;
  ///
  unsigned int index_;
  ///
  unsigned int selected_;
  ///
  bool lock_;
  ///
  Color selectedCol_;
};  


}

#endif // !_LISTBOX_H
