/*
 * Decompiled with CFR 0.152.
 */
package org.kde.kjas.server;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintStream;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import org.kde.kjas.server.Console;
import org.kde.kjas.server.KJASConsoleStream;
import org.kde.kjas.server.Main;

public class KJASSwingConsole
extends JFrame
implements Console {
    private boolean force_append = true;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JButton clearButton;
    private JTextArea textField;
    private JButton closeButton;
    private JButton copyButton;

    public KJASSwingConsole() {
        Object object;
        Object object2;
        Object object3;
        this.initComponents();
        this.setSize(500, 300);
        PrintStream printStream = new PrintStream(new KJASConsoleStream(this));
        System.setOut(printStream);
        System.setErr(printStream);
        try {
            object3 = this.getClass().getClassLoader().getResource("images/beanicon.png");
            if (object3 != null) {
                object2 = Toolkit.getDefaultToolkit();
                object = ((Toolkit)object2).createImage((URL)object3);
                this.setIconImage((Image)object);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.out.println("Java VM version: " + System.getProperty("java.version"));
        System.out.println("Java VM vendor:  " + System.getProperty("java.vendor"));
        object3 = System.getProperty("http.proxyHost");
        object2 = System.getProperty("http.proxyPort");
        if (object3 != null) {
            System.out.println("Proxy: " + (String)object3 + ":" + (String)object2);
        }
        object = System.getSecurityManager();
        Main.debug("SecurityManager=" + object);
        if (object == null) {
            System.out.println("WARNING: Security Manager disabled!");
            this.textField.setForeground(Color.red);
        }
        this.force_append = false;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.clearButton = new JButton();
        this.closeButton = new JButton();
        this.copyButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.textField = new JTextArea();
        this.setTitle("Konqueror Java Console");
        this.setFont(new Font("Monospaced", 0, 10));
        this.setName("KJAS Console");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                KJASSwingConsole.this.exitForm(windowEvent);
            }
        });
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
        this.clearButton.setText("clear");
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KJASSwingConsole.this.clearButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add((Component)this.clearButton, "West");
        this.closeButton.setText("close");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KJASSwingConsole.this.closeButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add((Component)this.closeButton, "East");
        this.copyButton.setText("copy");
        this.copyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KJASSwingConsole.this.copyButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add((Component)this.copyButton, "Center");
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.textField.setColumns(40);
        this.textField.setEditable(false);
        this.textField.setRows(10);
        this.textField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                KJASSwingConsole.this.textFieldKeyPressed(keyEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.textField);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.pack();
    }

    private void textFieldKeyPressed(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        switch (c) {
            case 'h': {
                this.append("Konqueror Java Console Help\n");
                this.append("  h: show help\n");
                this.append("  g: run garbage collection\n");
                this.append("  m: show memory info\n");
                this.append("  t: list threads\n");
            }
            case 'g': {
                this.append("Running Garbage Collection ...\n");
                System.gc();
            }
            case 'm': {
                this.append("Total Memory: " + Runtime.getRuntime().totalMemory() + " bytes\n");
                this.append("Free Memory : " + Runtime.getRuntime().freeMemory() + " bytes\n");
                break;
            }
            case 't': {
                this.showThreads();
            }
        }
    }

    private void showThreads() {
        ThreadGroup threadGroup;
        Thread thread = Thread.currentThread();
        ThreadGroup threadGroup2 = thread.getThreadGroup();
        while ((threadGroup = threadGroup2.getParent()) != null) {
            threadGroup2 = threadGroup;
        }
        threadGroup2.list();
    }

    private void copyButtonActionPerformed(ActionEvent actionEvent) {
        this.textField.selectAll();
        this.textField.copy();
    }

    private void closeButtonActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    private void clearButtonActionPerformed(ActionEvent actionEvent) {
        this.textField.setText("");
    }

    private void exitForm(WindowEvent windowEvent) {
        this.setVisible(false);
    }

    public static void main(String[] stringArray) {
        new KJASSwingConsole().show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(String string) {
        if (string == null || !this.isVisible() && !this.force_append) {
            return;
        }
        int n = string.length();
        JTextArea jTextArea = this.textField;
        synchronized (jTextArea) {
            int n2 = this.textField.getCaretPosition();
            this.textField.append(string);
            this.textField.setCaretPosition(n2 + n);
        }
    }
}

