/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Defaults;
import java.awt.Toolkit;
import java.awt.peer.FontPeer;
import java.io.Serializable;
import kaffe.util.Ptr;

public class Font
implements Serializable {
    public static final int PLAIN = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    private static final long serialVersionUID = -4206021311591459213L;
    Ptr nativeData;
    protected String name;
    protected int style;
    protected int size;

    public static Font decode(String string) {
        int n = 0;
        int n2 = 12;
        int n3 = 0;
        String string2 = string;
        int n4 = string.indexOf(45);
        if (n4 >= 0) {
            string2 = string.substring(0, n4);
            if (string.regionMatches(true, ++n4, "plain-", 0, 6)) {
                n3 = 6;
            } else if (string.regionMatches(true, n4, "bold-", 0, 5)) {
                n = 1;
                n3 = 5;
            } else if (string.regionMatches(true, n4, "italic-", 0, 7)) {
                n = 2;
                n3 = 7;
            } else if (string.regionMatches(true, n4, "bolditalic-", 0, 11)) {
                n = 3;
                n3 = 11;
            }
            if (n3 > 0) {
                n4 += n3;
                n2 = 0;
                int n5 = string.length();
                while (n4 < n5) {
                    char c = string.charAt(n4);
                    if (c < '0' || c > '9') break;
                    n2 = n2 * 10 + (c - 48);
                    ++n4;
                }
            }
        }
        Font font = new Font(string2, n, n2);
        return font;
    }

    String encode() {
        String string = this.style == 0 ? "-plain-" : (this.style == 2 ? "-italic-" : (this.style == 1 ? "-bold-" : "-bolditalic-"));
        return this.name + string + this.size;
    }

    public boolean equals(Object object) {
        if (object instanceof Font) {
            Font font = (Font)object;
            if (!font.name.equals(this.name)) {
                return false;
            }
            if (font.style != this.style) {
                return false;
            }
            return font.size == this.size;
        }
        return false;
    }

    protected void finalize() throws Throwable {
        if (this.nativeData != null) {
            Toolkit.fntFreeFont(this.nativeData);
            this.nativeData = null;
        }
        super.finalize();
    }

    public String getFamily() {
        return System.getProperty("awt.font." + this.name.toLowerCase(), this.name);
    }

    public static Font getFont(String string) {
        return Font.getFont(string, null);
    }

    public static Font getFont(String string, Font font) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            return Font.decode(string2);
        }
        return font;
    }

    public String getName() {
        return this.name;
    }

    public FontPeer getPeer() {
        return null;
    }

    public int getSize() {
        return this.size;
    }

    public int getStyle() {
        return this.style;
    }

    public boolean isBold() {
        return (this.style & 1) != 0;
    }

    public boolean isItalic() {
        return (this.style & 2) != 0;
    }

    public boolean isPlain() {
        return this.style == 0;
    }

    public String toString() {
        String string = "";
        if (this.style == 0) {
            string = "plain";
        } else {
            if ((this.style & 1) != 0) {
                string = "bold";
            }
            if ((this.style & 2) != 0) {
                string = string + "italic";
            }
        }
        return this.getClass().getName() + " [" + this.name + "," + string + "," + this.size + "]";
    }

    public Font(String string, int n, int n2) {
        this.name = string;
        this.style = n;
        this.size = n2;
        this.name = this.name.intern();
        String string2 = this.name == "Default" ? Defaults.FsDefault : (this.name == "Monospaced" ? Defaults.FsMonospaced : (this.name == "SansSerif" ? Defaults.FsSansSerif : (this.name == "Serif" ? Defaults.FsSerif : (this.name == "Dialog" ? Defaults.FsDialog : (this.name == "DialogInput" ? Defaults.FsDialogInput : (this.name == "ZapfDingbats" ? Defaults.FsZapfDingbats : (this.name == "Helvetica" ? Defaults.FsSansSerif : (this.name == "TimesRoman" ? Defaults.FsSerif : (this.name == "Courier" ? Defaults.FsMonospaced : this.name)))))))));
        this.nativeData = Toolkit.fntInitFont(string2, this.style, this.size);
    }
}

