/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.beans.Beans;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.jasper.JasperException;

public class BeanRepository {
    Vector sessionBeans = new Vector(11);
    Vector pageBeans = new Vector(11);
    Vector appBeans = new Vector(11);
    Vector requestBeans = new Vector(11);
    Hashtable beanTypes = new Hashtable();
    ClassLoader loader;

    public BeanRepository(ClassLoader loader) {
        this.loader = loader;
    }

    public boolean checkSessionBean(String s) {
        return this.sessionBeans.contains(s);
    }

    public void addSessionBean(String s, String type) throws JasperException {
        this.sessionBeans.addElement(s);
        this.putBeanType(s, type);
    }

    public boolean hasSessionBeans() {
        return !this.sessionBeans.isEmpty();
    }

    public Enumeration getSessionBeans() {
        return this.sessionBeans.elements();
    }

    public boolean checkApplicationBean(String s) {
        return this.appBeans.contains(s);
    }

    public void addApplicationBean(String s, String type) throws JasperException {
        this.appBeans.addElement(s);
        this.putBeanType(s, type);
    }

    public boolean hasApplicationBeans() {
        return !this.appBeans.isEmpty();
    }

    public Enumeration getApplicationBeans() {
        return this.appBeans.elements();
    }

    public boolean checkRequestBean(String s) {
        return this.requestBeans.contains(s);
    }

    public void addRequestBean(String s, String type) throws JasperException {
        this.requestBeans.addElement(s);
        this.putBeanType(s, type);
    }

    public boolean hasRequestBeans() {
        return !this.requestBeans.isEmpty();
    }

    public Enumeration getRequestBeans() {
        return this.requestBeans.elements();
    }

    public boolean checkPageBean(String s) {
        return this.pageBeans.contains(s);
    }

    public void addPageBean(String s, String type) throws JasperException {
        this.pageBeans.addElement(s);
        this.putBeanType(s, type);
    }

    public boolean hasPageBeans() {
        return !this.pageBeans.isEmpty();
    }

    public Enumeration getPageBeans() {
        return this.pageBeans.elements();
    }

    public boolean ClassFound(String clsname) throws ClassNotFoundException {
        Class<?> cls = null;
        cls = this.loader.loadClass(clsname);
        return cls != null;
    }

    public Class getBeanType(String bean) throws JasperException {
        Class<?> cls = null;
        try {
            cls = this.loader.loadClass((String)this.beanTypes.get(bean));
        }
        catch (ClassNotFoundException ex) {
            throw new JasperException(ex);
        }
        return cls;
    }

    public void putBeanType(String bean, String type) throws JasperException {
        try {
            this.beanTypes.put(bean, type);
        }
        catch (Exception ex) {
            throw new JasperException(ex);
        }
    }

    public void removeBeanType(String bean) {
        this.beanTypes.remove(bean);
    }

    public boolean checkVariable(String bean) {
        return this.checkPageBean(bean) || this.checkSessionBean(bean) || this.checkRequestBean(bean) || this.checkApplicationBean(bean);
    }

    public Class getClass(String clsname) throws ClassNotFoundException {
        Class<?> cls = null;
        if (clsname != null) {
            cls = this.loader.loadClass(clsname);
        }
        return cls;
    }

    public boolean beanFound(String beanName) throws ClassNotFoundException {
        try {
            Beans.instantiate(this.loader, beanName);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }
}

