/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.service.connector;

import java.io.IOException;
import org.apache.tomcat.core.ResponseImpl;
import org.apache.tomcat.service.connector.JNIConnectionHandler;
import org.apache.tomcat.util.MimeHeaderField;

class JNIResponseAdapter
extends ResponseImpl {
    JNIConnectionHandler h;
    long s;
    long l;

    public JNIResponseAdapter(JNIConnectionHandler h) {
        this.h = h;
    }

    protected void setRequestAttr(long s, long l) throws IOException {
        this.s = s;
        this.l = l;
    }

    public void endHeaders() throws IOException {
        if (this.request.getProtocol() == null) {
            return;
        }
        super.endHeaders();
        if (this.request.getContext() != null) {
            this.setHeader("Servlet-Engine", this.request.getContext().getEngineHeader());
        }
        int hcnt = 0;
        String[] headerNames = null;
        String[] headerValues = null;
        this.headers.removeHeader("Status");
        hcnt = this.headers.size();
        headerNames = new String[hcnt];
        headerValues = new String[hcnt];
        int i = 0;
        while (i < hcnt) {
            MimeHeaderField h = this.headers.getField(i);
            headerNames[i] = h.getName();
            headerValues[i] = h.getValue();
            ++i;
        }
        if (this.h.startReasponse(this.s, this.l, this.status, ResponseImpl.getMessage(this.status), headerNames, headerValues, hcnt) <= 0) {
            throw new IOException("Error: JNI startReasponse implementation error");
        }
    }

    public void doWrite(byte[] buf, int pos, int count) throws IOException {
        if (this.h.write(this.s, this.l, buf, pos, count) <= 0) {
            throw new IOException("Error: JNI implementation error");
        }
    }
}

