/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.mail;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.mail.MailPrintStream;
import org.apache.tools.mail.SmtpResponseReader;

public class MailMessage {
    String host;
    String from;
    Vector to;
    Vector cc;
    Hashtable headers;
    MailPrintStream out;
    SmtpResponseReader in;
    Socket socket;

    public MailMessage() throws IOException {
        this("localhost");
    }

    public MailMessage(String host) throws IOException {
        this.host = host;
        this.to = new Vector();
        this.cc = new Vector();
        this.headers = new Hashtable();
        this.setHeader("X-Mailer", "org.apache.tools.mail.MailMessage (jakarta.apache.org)");
        this.connect();
        this.sendHelo();
    }

    public void bcc(String bcc) throws IOException {
        this.sendRcpt(bcc);
    }

    public void cc(String cc) throws IOException {
        this.sendRcpt(cc);
        this.cc.addElement(cc);
    }

    void connect() throws IOException {
        this.socket = new Socket(this.host, 25);
        this.out = new MailPrintStream(new BufferedOutputStream(this.socket.getOutputStream()));
        this.in = new SmtpResponseReader(this.socket.getInputStream());
        this.getReady();
    }

    void disconnect() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
        if (this.in != null) {
            this.in.close();
        }
        if (this.socket != null) {
            this.socket.close();
        }
    }

    void flushHeaders() throws IOException {
        Enumeration e = this.headers.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = (String)this.headers.get(name);
            this.out.println(String.valueOf(name) + ": " + value);
        }
        this.out.println();
        this.out.flush();
    }

    public void from(String from) throws IOException {
        this.sendFrom(from);
        this.from = from;
    }

    public PrintStream getPrintStream() throws IOException {
        this.setFromHeader();
        this.setToHeader();
        this.setCcHeader();
        this.sendData();
        this.flushHeaders();
        return this.out;
    }

    void getReady() throws IOException {
        String response = this.in.getResponse();
        int[] ok = new int[]{220};
        if (!this.isResponseOK(response, ok)) {
            throw new IOException("Didn't get introduction from server: " + response);
        }
    }

    boolean isResponseOK(String response, int[] ok) {
        int i = 0;
        while (i < ok.length) {
            if (response.startsWith(String.valueOf(ok[i]))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static String sanitizeAddress(String s) {
        int paramDepth = 0;
        int start = 0;
        int end = 0;
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c == '(') {
                ++paramDepth;
                if (start == 0) {
                    end = i;
                }
            } else if (c == ')') {
                --paramDepth;
                if (end == 0) {
                    start = i + 1;
                }
            } else if (paramDepth == 0 && c == '<') {
                start = i + 1;
            } else if (paramDepth == 0 && c == '>') {
                end = i;
            }
            ++i;
        }
        if (end == 0) {
            end = len;
        }
        return s.substring(start, end);
    }

    void send(String msg, int[] ok) throws IOException {
        this.out.rawPrint(String.valueOf(msg) + "\r\n");
        String response = this.in.getResponse();
        if (!this.isResponseOK(response, ok)) {
            throw new IOException("Unexpected reply to command: " + msg + ": " + response);
        }
    }

    public void sendAndClose() throws IOException {
        this.sendDot();
        this.sendQuit();
        this.disconnect();
    }

    void sendData() throws IOException {
        int[] ok = new int[]{354};
        this.send("DATA", ok);
    }

    void sendDot() throws IOException {
        int[] ok = new int[]{250};
        this.send("\r\n.", ok);
    }

    void sendFrom(String from) throws IOException {
        int[] ok = new int[]{250};
        this.send("MAIL FROM: <" + MailMessage.sanitizeAddress(from) + ">", ok);
    }

    void sendHelo() throws IOException {
        String local = InetAddress.getLocalHost().getHostName();
        int[] ok = new int[]{250};
        this.send("HELO " + local, ok);
    }

    void sendQuit() throws IOException {
        int[] ok = new int[]{221};
        this.send("QUIT", ok);
    }

    void sendRcpt(String rcpt) throws IOException {
        int[] ok = new int[]{250, 251};
        this.send("RCPT TO: <" + MailMessage.sanitizeAddress(rcpt) + ">", ok);
    }

    void setCcHeader() {
        this.setHeader("Cc", this.vectorToList(this.cc));
    }

    void setFromHeader() {
        this.setHeader("From", this.from);
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void setSubject(String subj) {
        this.headers.put("Subject", subj);
    }

    void setToHeader() {
        this.setHeader("To", this.vectorToList(this.to));
    }

    public void to(String to) throws IOException {
        this.sendRcpt(to);
        this.to.addElement(to);
    }

    String vectorToList(Vector v) {
        StringBuffer buf = new StringBuffer();
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            buf.append(e.nextElement());
            if (!e.hasMoreElements()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }
}

