/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecTask;

public class SignJar
extends Task {
    protected String jar;
    protected String alias;
    protected String keystore;
    protected String storepass;
    protected String storetype;
    protected String keypass;
    protected String sigfile;
    protected String signedjar;
    protected boolean verbose;
    protected boolean internalsf;
    protected boolean sectionsonly;

    public void execute() throws BuildException {
        if (Project.getJavaVersion().equals("1.1")) {
            throw new BuildException("The signjar task is only available on JDK versions 1.2 or greater");
        }
        if (this.jar == null) {
            throw new BuildException("jar attribute must be set");
        }
        if (this.alias == null) {
            throw new BuildException("alias attribute must be set");
        }
        if (this.storepass == null) {
            throw new BuildException("storepass attribute must be set");
        }
        if (this.isUpToDate()) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        ExecTask cmd = (ExecTask)this.project.createTask("exec");
        cmd.setExecutable("jarsigner");
        if (this.keystore != null) {
            cmd.createArg().setValue("-keystore");
            cmd.createArg().setValue(this.keystore);
        }
        if (this.storepass != null) {
            cmd.createArg().setValue("-storepass");
            cmd.createArg().setValue(this.storepass);
        }
        if (this.storetype != null) {
            cmd.createArg().setValue("-storetype");
            cmd.createArg().setValue(this.storetype);
        }
        if (this.keypass != null) {
            cmd.createArg().setValue("-keypass");
            cmd.createArg().setValue(this.keypass);
        }
        if (this.sigfile != null) {
            cmd.createArg().setValue("-sigfile");
            cmd.createArg().setValue(this.sigfile);
        }
        if (this.signedjar != null) {
            cmd.createArg().setValue("-signedjar");
            cmd.createArg().setValue(this.signedjar);
        }
        if (this.verbose) {
            cmd.createArg().setValue("-verbose");
        }
        if (this.internalsf) {
            cmd.createArg().setValue("-internalsf");
        }
        if (this.sectionsonly) {
            cmd.createArg().setValue("-sectionsonly");
        }
        cmd.createArg().setValue(this.jar);
        cmd.createArg().setValue(this.alias);
        this.log("Signing Jar : " + new File(this.jar).getAbsolutePath());
        cmd.setFailonerror(true);
        cmd.setTaskName(this.getTaskName());
        cmd.execute();
    }

    protected boolean isUpToDate() {
        if (this.jar != null && this.signedjar != null) {
            File jarFile = new File(this.jar);
            File signedjarFile = new File(this.signedjar);
            if (!jarFile.exists()) {
                return false;
            }
            if (!signedjarFile.exists()) {
                return false;
            }
            if (jarFile.equals(signedjarFile)) {
                return false;
            }
            if (signedjarFile.lastModified() > jarFile.lastModified()) {
                return true;
            }
        }
        return false;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setInternalsf(boolean internalsf) {
        this.internalsf = internalsf;
    }

    public void setJar(String jar) {
        this.jar = jar;
    }

    public void setKeypass(String keypass) {
        this.keypass = keypass;
    }

    public void setKeystore(String keystore) {
        this.keystore = keystore;
    }

    public void setSectionsonly(boolean sectionsonly) {
        this.sectionsonly = sectionsonly;
    }

    public void setSigfile(String sigfile) {
        this.sigfile = sigfile;
    }

    public void setSignedjar(String signedjar) {
        this.signedjar = signedjar;
    }

    public void setStorepass(String storepass) {
        this.storepass = storepass;
    }

    public void setStoretype(String storetype) {
        this.storetype = storetype;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

