/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.extension;

import java.io.File;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.extension.Extension;
import org.apache.tools.ant.taskdefs.optional.extension.ExtensionAdapter;
import org.apache.tools.ant.taskdefs.optional.extension.LibFileSet;
import org.apache.tools.ant.types.FileSet;

public class ExtensionUtil {
    static ArrayList toExtensions(ArrayList adapters) throws BuildException {
        ArrayList<Extension> results = new ArrayList<Extension>();
        int size = adapters.size();
        int i = 0;
        while (i < size) {
            ExtensionAdapter adapter = (ExtensionAdapter)((Object)adapters.get(i));
            Extension extension = adapter.toExtension();
            results.add(extension);
            ++i;
        }
        return results;
    }

    static void extractExtensions(Project project, ArrayList librarys, ArrayList fileset) throws BuildException {
        if (!fileset.isEmpty()) {
            Extension[] extensions = ExtensionUtil.getExtensions(project, fileset);
            int i = 0;
            while (i < extensions.length) {
                librarys.add(extensions[i]);
                ++i;
            }
        }
    }

    private static Extension[] getExtensions(Project project, ArrayList librarys) throws BuildException {
        ArrayList extensions = new ArrayList();
        Iterator iterator = ((AbstractList)librarys).iterator();
        while (iterator.hasNext()) {
            FileSet fileSet = (FileSet)iterator.next();
            boolean includeImpl = true;
            boolean includeURL = true;
            if (fileSet instanceof LibFileSet) {
                LibFileSet libFileSet = (LibFileSet)fileSet;
                includeImpl = libFileSet.isIncludeImpl();
                includeURL = libFileSet.isIncludeURL();
            }
            DirectoryScanner scanner = fileSet.getDirectoryScanner(project);
            File basedir = scanner.getBasedir();
            String[] files = scanner.getIncludedFiles();
            int i = 0;
            while (i < files.length) {
                File file = new File(basedir, files[i]);
                ExtensionUtil.loadExtensions(file, extensions, includeImpl, includeURL);
                ++i;
            }
        }
        return extensions.toArray(new Extension[extensions.size()]);
    }

    private static void loadExtensions(File file, ArrayList extensionList, boolean includeImpl, boolean includeURL) throws BuildException {
        try {
            JarFile jarFile = new JarFile(file);
            Extension[] extensions = Extension.getAvailable(jarFile.getManifest());
            int i = 0;
            while (i < extensions.length) {
                Extension extension = extensions[i];
                ExtensionUtil.addExtension(extensionList, extension, includeImpl, includeURL);
                ++i;
            }
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }

    private static void addExtension(ArrayList extensionList, Extension originalExtension, boolean includeImpl, boolean includeURL) {
        boolean hasImplAttributes;
        Extension extension = originalExtension;
        if (!includeURL && null != extension.getImplementationURL()) {
            extension = new Extension(extension.getExtensionName(), extension.getSpecificationVersion().toString(), extension.getSpecificationVendor(), extension.getImplementationVersion().toString(), extension.getImplementationVendor(), extension.getImplementationVendorID(), null);
        }
        boolean bl = hasImplAttributes = null != extension.getImplementationURL() || null != extension.getImplementationVersion() || null != extension.getImplementationVendorID() || null != extension.getImplementationVendor();
        if (!includeImpl && hasImplAttributes) {
            extension = new Extension(extension.getExtensionName(), extension.getSpecificationVersion().toString(), extension.getSpecificationVendor(), null, null, null, extension.getImplementationURL());
        }
        extensionList.add(extension);
    }

    static Manifest getManifest(File file) throws BuildException {
        try {
            JarFile jarFile = new JarFile(file);
            return jarFile.getManifest();
        }
        catch (IOException ioe) {
            throw new BuildException(ioe.getMessage(), (Throwable)ioe);
        }
    }
}

