'\"
'\" Generated from ./modules/base64/uuencode.man by mpexpand with fmt.nroff
'\"
.so man.macros
.TH "uuencode" n 1.0.1 base64 "encode/decoding a binary file"
.BS
.SH NAME
uuencode \- encode/decoding a binary file
.SH "SYNOPSIS"
package require \fBTcl 8\fR
.sp
package require \fBuuencode ?1.0.1?\fR
.sp
\fB::uuencode::encode\fR \fIstring\fR\fR
.sp
\fB::uuencode::decode\fR \fIstring\fR\fR
.sp
\fB::uuencode::uuencode\fR ?-name \fIstring\fR? ?-mode \fIoctal\fR? (-file \fIfilename\fR | ?--? \fIstring\fR)\fR
.sp
\fB::uuencode::uudecode\fR (-file \fIfilename\fR | ?--? \fIstring\fR)\fR
.sp
.BE
.SH "DESCRIPTION"
.PP
This package provides a Tcl-only implementation of the uuencode(1) and
uudecode(1) commands. This encoding packs binary data into printable
ASCII characters.
.TP
\fB::uuencode::encode\fR \fIstring\fR\fR
returns the uuencoded data. This will encode all the data passed in
even if this is longer than the uuencode maximum line length. If the
number of input bytes is not a multiple of 3 then additional 0 bytes
are added to pad the string.
.TP
\fB::uuencode::decode\fR \fIstring\fR\fR
Decodes the given encoded data. This will return any padding
characters as well and it is the callers responsibility to deal with
handling the actual length of the encoded data. (see uuencode).
.TP
\fB::uuencode::uuencode\fR ?-name \fIstring\fR? ?-mode \fIoctal\fR? (-file \fIfilename\fR | ?--? \fIstring\fR)\fR
.TP
\fB::uuencode::uudecode\fR (-file \fIfilename\fR | ?--? \fIstring\fR)\fR
UUDecode a file or block of data. A file may contain more than one
embedded file so the result is a list where each element is a three
element list of filename, mode value and data.
.SH "OPTIONS"
.TP
-filename name
Cause the uuencode or uudecode commands to read their data from the
named file rather that taking a string parameter.
.TP
-name string
The uuencoded data header line contains the suggested file name to be
used when unpacking the data. Use this option to change this from the
default of "data.dat".
.TP
-mode octal
The uuencoded data header line contains a suggested permissions bit
pattern expressed as an octal string. To change the default of 0644
you can set this option. For instance, 0755 would be suitable for an
executable. See chmod(1).
.SH "EXAMPLES"
.PP
.nf
% set d [uuencode::encode "Hello World!"]
2&5L;&\\@5V]R;&0A
.fi
.PP
.nf
% uuencode::uudecode $d
Hello World!
.fi
.PP
.nf
% set d [uuencode::uuencode -name hello.txt "Hello World"]
begin 644 hello.txt
+2&5L;&\@5V]R;&0`
`
end
.fi
.PP
.nf
% uuencode::uudecode $d
{hello.txt 644 {Hello World}}
.fi
.SH "KEYWORDS"
encoding, uuencode
