'\" -*- tcl -*-
'\"
'\" Generated from ./modules/pop3d/pop3d_udb.man by mpexpand with fmt.nroff
'\"
.so man.macros
.TH "pop3d::udb" n 1.0 pop3d "Tcl POP3 Server Package"
.BS
.SH NAME
pop3d::udb \- Simple user database for pop3d
.SH "SYNOPSIS"
package require \fBTcl 8.2\fR
.sp
package require \fBpop3d::udb ?1.0?\fR
.sp
\fB::pop3d::udb::new\fR ?\fIdbName\fR?\fR
.sp
\fBdbName\fR \fIoption\fR ?\fIarg arg ...\fR?\fR
.sp
\fIdbName\fR \fBdestroy\fR\fR
.sp
\fIdbName\fR \fBadd\fR \fIuser pwd storage\fR\fR
.sp
\fIdbName\fR \fBremove\fR \fIuser\fR\fR
.sp
\fIdbName\fR \fBrename\fR \fIuser newName\fR\fR
.sp
\fIdbName\fR \fBlookup\fR \fIuser\fR\fR
.sp
\fIdbName\fR \fBexists\fR \fIuser\fR\fR
.sp
\fIdbName\fR \fBwho\fR\fR
.sp
\fIdbName\fR \fBsave\fR ?\fIfile\fR?\fR
.sp
\fIdbName\fR \fBread\fR \fIfile\fR\fR
.sp
.BE
.SH "DESCRIPTION"
.PP
The package \fBpop3d::udb\fR provides simple in memory databases
which can be used in conjunction with the pop3 server core provided by
the package \fBpop3d\fR. The databases will use the names of users
as keys and associates passwords and storage references with them.
.PP
Objects created by this package can be directly used in the
authentication callback of pop3 servers following the same interface
as servers created by the package \fBpop3d\fR.
.PP
.TP
\fB::pop3d::udb::new\fR ?\fIdbName\fR?\fR
This command creates a new database object with an associated global
Tcl command whose name is \fIdbName\fR.
The command \fBdbName\fR may be used to invoke various operations on
the database.  It has the following general form:
.TP
\fBdbName\fR \fIoption\fR ?\fIarg arg ...\fR?\fR
\fIOption\fR and the \fIarg\fRs determine the exact behavior of the
command.
.PP
The following commands are possible for database objects:
.TP
\fIdbName\fR \fBdestroy\fR\fR
Destroys the database object.
.TP
\fIdbName\fR \fBadd\fR \fIuser pwd storage\fR\fR
Add a new user or changes the data of an existing user. Stores
\fIpassword\fR and \fIstorage\fR reference for the given \fIuser\fR.
.TP
\fIdbName\fR \fBremove\fR \fIuser\fR\fR
Removes the specified \fIuser\fR from the database.
.TP
\fIdbName\fR \fBrename\fR \fIuser newName\fR\fR
Changes the name of the specified \fIuser\fR to \fInewName\fR.
.TP
\fIdbName\fR \fBlookup\fR \fIuser\fR\fR
Searches the database for the specified \fIuser\fR and returns a
two-element list containing the associated password and storage
reference, in this order. Throws an error if the user could not be
found. This is the interface as expected by the authentication
callback of package \fBpop3d\fR.
.TP
\fIdbName\fR \fBexists\fR \fIuser\fR\fR
Returns true if the specified \fIuser\fR is known to the database,
else false.
.TP
\fIdbName\fR \fBwho\fR\fR
Returns a list of users known to the database.
.TP
\fIdbName\fR \fBsave\fR ?\fIfile\fR?\fR
Saves the contents of the database into the given \fIfile\fR. If the
file is not specified the system will use the path last used in a call
to \fIdbName\fR \fBread\fR. The generated file can be read by the
\fBread\fR method.
.TP
\fIdbName\fR \fBread\fR \fIfile\fR\fR
Reads the specified \fIfile\fR and adds the contained user definitions
to the database. As the file is actually \fBsource\fR'd a safe
interpreter is employed to safeguard against malicious code. This
interpreter knows the \fBadd\fR command for adding users and their
associated data to this database. This command has the same argument
signature as the method \fBadd\fR. The path of the \fIfile\fR is
remembered internally so that it can be used in the next call of
\fIdbName\fR \fBsave\fR without an argument.
.SH "KEYWORDS"
pop3, internet, network, protocol, rfc1939
