'\" -*- tcl -*-
'\"
'\" Generated from ./modules/struct/matrix.man by mpexpand with fmt.nroff
'\"
.so man.macros
.TH "matrix" n 1.2.1 struct "Tcl Data Structures"
.BS
.SH NAME
matrix \- Create and manipulate matrix objects
.SH "SYNOPSIS"
package require \fBTcl 8.2\fR
.sp
package require \fBstruct ?1.2.1?\fR
.sp
\fBmatrixName\fR \fIoption\fR ?\fIarg arg ...\fR?\fR
.sp
\fImatrixName\fR \fBadd column\fR ?\fIvalues\fR?\fR
.sp
\fImatrixName\fR \fBadd row\fR ?\fIvalues\fR?\fR
.sp
\fImatrixName\fR \fBadd columns\fR \fIn\fR\fR
.sp
\fImatrixName\fR \fBadd rows\fR \fIn\fR\fR
.sp
\fImatrixName\fR \fBcells\fR\fR
.sp
\fImatrixName\fR \fBcellsize\fR \fIcolumn row\fR\fR
.sp
\fImatrixName\fR \fBcolumns\fR\fR
.sp
\fImatrixName\fR \fBcolumnwidth\fR \fIcolumn\fR\fR
.sp
\fImatrixName\fR \fBdelete column\fR \fIcolumn\fR\fR
.sp
\fImatrixName\fR \fBdelete row\fR \fIrow\fR\fR
.sp
\fImatrixName\fR \fBdestroy\fR\fR
.sp
\fImatrixName\fR \fBformat 2string\fR ?\fIreport\fR?\fR
.sp
\fImatrixName\fR \fBformat 2chan\fR ??\fIreport\fR? \fIchannel\fR?\fR
.sp
\fImatrixName\fR \fBget cell\fR \fIcolumn row\fR\fR
.sp
\fImatrixName\fR \fBget column\fR \fIcolumn\fR\fR
.sp
\fImatrixName\fR \fBget rect\fR \fIcolumn_tl row_tl column_br row_br\fR\fR
.sp
\fImatrixName\fR \fBget row\fR \fIrow\fR\fR
.sp
\fImatrixName\fR \fBinsert column\fR \fIcolumn\fR ?\fIvalues\fR?\fR
.sp
\fImatrixName\fR \fBinsert row\fR \fIrow\fR ?\fIvalues\fR?\fR
.sp
\fImatrixName\fR \fBlink\fR ?-transpose? \fIarrayvar\fR\fR
.sp
\fImatrixName\fR \fBrowheight\fR \fIrow\fR\fR
.sp
\fImatrixName\fR \fBrows\fR\fR
.sp
\fImatrixName\fR \fBsearch\fR ?-nocase? ?-exact|-glob|-regexp? \fBall\fR \fIpattern\fR\fR
.sp
\fImatrixName\fR \fBsearch\fR ?-nocase? ?-exact|-glob|-regexp? \fBcolumn\fR \fIcolumn pattern\fR\fR
.sp
\fImatrixName\fR \fBsearch\fR ?-nocase? ?-exact|-glob|-regexp? \fBrow\fR \fIrow pattern\fR\fR
.sp
\fImatrixName\fR \fBsearch\fR ?-nocase? ?-exact|-glob|-regexp? \fBrect\fR \fIcolumn_tl row_tl column_br row_br pattern\fR\fR
.sp
\fImatrixName\fR \fBset cell\fR \fIcolumn row value\fR\fR
.sp
\fImatrixName\fR \fBset column\fR \fIcolumn values\fR\fR
.sp
\fImatrixName\fR \fBset rect\fR \fIcolumn row values\fR\fR
.sp
\fImatrixName\fR \fBset row\fR \fIrow values\fR\fR
.sp
\fImatrixName\fR \fBswap columns\fR \fIcolumn_a column_b\fR\fR
.sp
\fImatrixName\fR \fBswap rows\fR \fIrow_a row_b\fR\fR
.sp
\fImatrixName\fR \fBunlink\fR \fIarrayvar\fR\fR
.sp
.BE
.SH "DESCRIPTION"
.PP
The \fB::struct::matrix\fR command creates a new matrix object with an
associated global Tcl command whose name is \fImatrixName\fR.  This
command may be used to invoke various operations on the matrix.  It has
the following general form:
.TP
\fBmatrixName\fR \fIoption\fR ?\fIarg arg ...\fR?\fR
\fIOption\fR and the \fIarg\fRs determine the exact behavior of the
command.
.PP
A matrix is a rectangular collection of cells, i.e. organized in rows
and columns. Each cell contains exactly one value of arbitrary
form. The cells in the matrix are addressed by pairs of integer
numbers, with the first (left) number in the pair specifying the
column and the second (right) number specifying the row the cell is
in. These indices are counted from 0 upward. The special non-numeric
index \fBend\fR refers to the last row or column in the matrix,
depending on the context. Indices of the form
\fBend\fR-\fBnumber\fR are counted from the end of the row or
column, like they are for standard Tcl lists. Trying to access
non-existing cells causes an error.
.PP
The matrices here are created empty, i.e. they have neither rows nor
columns. The user then has to add rows and columns as needed by his
application. A specialty of this structure is the ability to export an
array-view onto its contents. Such can be used by tkTable, for
example, to link the matrix into the display.
.PP
The following commands are possible for matrix objects:
.TP
\fImatrixName\fR \fBadd column\fR ?\fIvalues\fR?\fR
Extends the matrix by one column and then acts like \fBsetcolumn\fR
(see below) on this new column if there were \fIvalues\fR
supplied. Without \fIvalues\fR the new cells will be set to the empty
string. The new column is appended immediately behind the last
existing column.
.TP
\fImatrixName\fR \fBadd row\fR ?\fIvalues\fR?\fR
Extends the matrix by one row and then acts like \fBsetrow\fR (see
below) on this new row if there were \fIvalues\fR supplied. Without
\fIvalues\fR the new cells will be set to the empty string. The new
row is appended immediately behind the last existing row.
.TP
\fImatrixName\fR \fBadd columns\fR \fIn\fR\fR
Extends the matrix by \fIn\fR columns. The new cells will be set to
the empty string. The new columns are appended immediately behind the
last existing column. A value of \fIn\fR equal to or smaller than 0 is
not allowed.
.TP
\fImatrixName\fR \fBadd rows\fR \fIn\fR\fR
Extends the matrix by \fIn\fR rows. The new cells will be set to the
empty string. The new rows are appended immediately behind the last
existing row. A value of \fIn\fR equal to or smaller than 0 is not
allowed.
.TP
\fImatrixName\fR \fBcells\fR\fR
Returns the number of cells currently managed by the matrix. This is
the product of \fBrows\fR and \fBcolumns\fR.
.TP
\fImatrixName\fR \fBcellsize\fR \fIcolumn row\fR\fR
Returns the length of the string representation of the value currently
contained in the addressed cell.
.TP
\fImatrixName\fR \fBcolumns\fR\fR
Returns the number of columns currently managed by the matrix.
.TP
\fImatrixName\fR \fBcolumnwidth\fR \fIcolumn\fR\fR
Returns the length of the longest string representation of all the
values currently contained in the cells of the addressed column if
these are all spanning only one line. For cell values spanning
multiple lines the length of their longest line goes into the
computation.
.TP
\fImatrixName\fR \fBdelete column\fR \fIcolumn\fR\fR
Deletes the specified column from the matrix and shifts all columns
with higher indices one index down.
.TP
\fImatrixName\fR \fBdelete row\fR \fIrow\fR\fR
Deletes the specified row from the matrix and shifts all row with
higher indices one index down.
.TP
\fImatrixName\fR \fBdestroy\fR\fR
Destroys the matrix, including its storage space and associated
command.
.TP
\fImatrixName\fR \fBformat 2string\fR ?\fIreport\fR?\fR
Formats the matrix using the specified report object and returns the
string containing the result of this operation. The report has to
support the \fBprintmatrix\fR method. If no \fIreport\fR is
specified the system will use an internal report definition to format
the matrix.
.TP
\fImatrixName\fR \fBformat 2chan\fR ??\fIreport\fR? \fIchannel\fR?\fR
Formats the matrix using the specified report object and writes the
string containing the result of this operation into the channel. The
report has to support the \fBprintmatrix2channel\fR method.  If no
\fIreport\fR is specified the system will use an internal report
definition to format the matrix. If no \fIchannel\fR is specified the
system will use \fBstdout\fR.
.TP
\fImatrixName\fR \fBget cell\fR \fIcolumn row\fR\fR
Returns the value currently contained in the cell identified by row
and column index.
.TP
\fImatrixName\fR \fBget column\fR \fIcolumn\fR\fR
Returns a list containing the values from all cells in the column
identified by the index. The contents of the cell in row 0 are stored
as the first element of this list.
.TP
\fImatrixName\fR \fBget rect\fR \fIcolumn_tl row_tl column_br row_br\fR\fR
Returns a list of lists of cell values. The values stored in the
result come from the sub-matrix whose top-left and bottom-right cells
are specified by \fIcolumn_tl, row_tl\fR and
\fIcolumn_br, row_br\fR resp. Note that the following equations have
to be true: "\fIcolumn_tl\fR <= \fIcolumn_br\fR" and "\fIrow_tl\fR <=
\fIrow_br\fR". The result is organized as follows: The outer list is
the list of rows, its elements are lists representing a single
row. The row with the smallest index is the first element of the outer
list. The elements of the row lists represent the selected cell
values. The cell with the smallest index is the first element in each
row list.
.TP
\fImatrixName\fR \fBget row\fR \fIrow\fR\fR
Returns a list containing the values from all cells in the row
identified by the index. The contents of the cell in column 0 are
stored as the first element of this list.
.TP
\fImatrixName\fR \fBinsert column\fR \fIcolumn\fR ?\fIvalues\fR?\fR
Extends the matrix by one column and then acts like \fBsetcolumn\fR
(see below) on this new column if there were \fIvalues\fR
supplied. Without \fIvalues\fR the new cells will be set to the empty
string. The new column is inserted just before the column specified by
the given index. This means, if \fIcolumn\fR is less than or equal to
zero, then the new column is inserted at the beginning of the matrix,
before the first column. If \fIcolumn\fR has the value \fBend\fR,
or if it is greater than or equal to the number of columns in the
matrix, then the new column is appended to the matrix, behind the last
column. The old column at the chosen index and all columns with higher
indices are shifted one index upward.
.TP
\fImatrixName\fR \fBinsert row\fR \fIrow\fR ?\fIvalues\fR?\fR
Extends the matrix by one row and then acts like \fBsetrow\fR (see
below) on this new row if there were \fIvalues\fR supplied. Without
\fIvalues\fR the new cells will be set to the empty string. The new
row is inserted just before the row specified by the given index. This
means, if \fIrow\fR is less than or equal to zero, then the new row is
inserted at the beginning of the matrix, before the first row. If
\fIrow\fR has the value \fBend\fR, or if it is greater than or
equal to the number of rows in the matrix, then the new row is
appended to the matrix, behind the last row. The old row at that index
and all rows with higher indices are shifted one index upward.
.TP
\fImatrixName\fR \fBlink\fR ?-transpose? \fIarrayvar\fR\fR
Links the matrix to the specified array variable. This means that the
contents of all cells in the matrix is stored in the array too, with
all changes to the matrix propagated there too. The contents of the
cell \fI(column,row)\fR is stored in the array using the key
\fIcolumn,row\fR. If the option \fB-transpose\fR is specified the
key \fIrow,column\fR will be used instead. It is possible to link the
matrix to more than one array. Note that the link is bidirectional,
i.e. changes to the array are mirrored in the matrix too.
.TP
\fImatrixName\fR \fBrowheight\fR \fIrow\fR\fR
Returns the height of the specified row in lines. This is the highest
number of lines spanned by a cell over all cells in the row.
.TP
\fImatrixName\fR \fBrows\fR\fR
Returns the number of rows currently managed by the matrix.
.TP
\fImatrixName\fR \fBsearch\fR ?-nocase? ?-exact|-glob|-regexp? \fBall\fR \fIpattern\fR\fR
Searches the whole matrix for cells matching the \fIpattern\fR and
returns a list with all matches. Each item in the aforementioned list
is a list itself and contains the column and row index of the matching
cell, in this order. The results are ordered by column first and row
second, both times in ascending order. This means that matches to the
left and the top of the matrix come before matches to the right and
down.
.sp
The type of the pattern (string, glob, regular expression) is
determined by the option after the \fBsearch\fR keyword. If no
option is given it defaults to \fB-exact\fR.
.sp
If the option \fB-nocase\fR is specified the search will be
case-insensitive.
.TP
\fImatrixName\fR \fBsearch\fR ?-nocase? ?-exact|-glob|-regexp? \fBcolumn\fR \fIcolumn pattern\fR\fR
Like \fBsearch all\fR, but the search is restricted to the
specified column.
.TP
\fImatrixName\fR \fBsearch\fR ?-nocase? ?-exact|-glob|-regexp? \fBrow\fR \fIrow pattern\fR\fR
Like \fBsearch all\fR, but the search is restricted to the
specified row.
.TP
\fImatrixName\fR \fBsearch\fR ?-nocase? ?-exact|-glob|-regexp? \fBrect\fR \fIcolumn_tl row_tl column_br row_br pattern\fR\fR
Like \fBsearch all\fR, but the search is restricted to the
specified rectangular area of the matrix.
.TP
\fImatrixName\fR \fBset cell\fR \fIcolumn row value\fR\fR
Sets the value in the cell identified by row and column index to the
data in the third argument.
.TP
\fImatrixName\fR \fBset column\fR \fIcolumn values\fR\fR
Sets the values in the cells identified by the column index to the
elements of the list provided as the third argument. Each element of
the list is assigned to one cell, with the first element going into
the cell in row 0 and then upward. If there are less values in the
list than there are rows the remaining rows are set to the empty
string. If there are more values in the list than there are rows the
superfluous elements are ignored. The matrix is not extended by this
operation.
.TP
\fImatrixName\fR \fBset rect\fR \fIcolumn row values\fR\fR
Takes a list of lists of cell values and writes them into the
submatrix whose top-left cell is specified by the two indices. If the
sublists of the outerlist are not of equal length the shorter sublists
will be filled with empty strings to the length of the longest
sublist. If the submatrix specified by the top-left cell and the
number of rows and columns in the \fIvalues\fR extends beyond the
matrix we are modifying the over-extending parts of the values are
ignored, i.e. essentially cut off. This subcommand expects its input
in the format as returned by \fBgetrect\fR.
.TP
\fImatrixName\fR \fBset row\fR \fIrow values\fR\fR
Sets the values in the cells identified by the row index to the
elements of the list provided as the third argument. Each element of
the list is assigned to one cell, with the first element going into
the cell in column 0 and then upward. If there are less values in the
list than there are columns the remaining columns are set to the empty
string. If there are more values in the list than there are columns
the superfluous elements are ignored. The matrix is not extended by
this operation.
.TP
\fImatrixName\fR \fBswap columns\fR \fIcolumn_a column_b\fR\fR
Swaps the contents of the two specified columns.
.TP
\fImatrixName\fR \fBswap rows\fR \fIrow_a row_b\fR\fR
Swaps the contents of the two specified rows.
.TP
\fImatrixName\fR \fBunlink\fR \fIarrayvar\fR\fR
Removes the link between the matrix and the specified arrayvariable,
if there is one.
.SH "EXAMPLES"
.PP
The examples below assume a 5x5 matrix M with the first row containing
the values 1 to 5, with 1 in the top-left cell. Each other row
contains the contents of the row above it, rotated by one cell to the
right.
.PP
.nf
 % M getrect 0 0 4 4
 {{1 2 3 4 5} {5 1 2 3 4} {4 5 1 2 3} {3 4 5 1 2} {2 3 4 5 1}}
.fi
.PP
.nf
 % M setrect 1 1 {{0 0 0} {0 0 0} {0 0 0}}
 % M getrect 0 0 4 4
 {{1 2 3 4 5} {5 0 0 0 4} {4 0 0 0 3} {3 0 0 0 2} {2 3 4 5 1}}
.fi
.PP
Assuming that the style definitions in the example section of the
manpage for the package \fBreport\fR are loaded into the
interpreter now an example which formats a matrix into a tabular
report. The code filling the matrix with data is not shown.  contains
useful data.
.PP
.nf
    % ::struct::matrix m
    % # ... fill m with data, assume 5 columns
    % ::report::report r 5 style captionedtable 1
    % m format 2string r
    +---+-------------------+-------+-------+--------+
    |000|VERSIONS:          |2:8.4a3|1:8.4a3|1:8.4a3%|
    +---+-------------------+-------+-------+--------+
    |001|CATCH return ok    |7      |13     |53.85   |
    |002|CATCH return error |68     |91     |74.73   |
    |003|CATCH no catch used|7      |14     |50.00   |
    |004|IF if true numeric |12     |33     |36.36   |
    |005|IF elseif          |15     |47     |31.91   |
    |   |true numeric       |       |       |        |
    +---+-------------------+-------+-------+--------+
    %
    % # alternate way of doing the above
    % r printmatrix m
.fi
.SH "KEYWORDS"
matrix
