<?php
// $Id: class_cpu.inc,v 1.4 2002/11/29 10:45:46 dijkstra Exp $
require_once("class_graph.inc");

class CPU_Graph extends Graph {
    function CPU_Graph() {
	// get all the sensible defaults from our parent class
	$this->init();
    }
    function execute($url) {
	$this->url2options($url);
	// and add a few private things
	$this->graphsettings["rawcmdline"] .=" -v '% cpu(".$this->get("name").")' -u 100 --rigid ";

	$this->shortcut = array_merge($this->shortcut, array(
	    "cpu" => array(
		"brief" => array(
		    "dsdefinition" => array(
			"DEF:A=".$this->get("rrdfile").":user:AVERAGE",
			"DEF:B=".$this->get("rrdfile").":nice:AVERAGE",
			"DEF:C=".$this->get("rrdfile").":system:AVERAGE",
			"DEF:D=".$this->get("rrdfile").":interrupt:AVERAGE",
			"DEF:E=".$this->get("rrdfile").":idle:AVERAGE"),
		    "graphdefinition" => array(
			"AREA:A#00FF00:'user'",
			"GPRINT:A:AVERAGE:'%.0lf\g'",
			"STACK:B#00FFFF:'nice'",
			"GPRINT:B:AVERAGE:'%.0lf\g'",
			"STACK:C#DDA0DD:'system'",
			"GPRINT:C:AVERAGE:'%.0lf\g'", 
			"STACK:D#9932CC:'interrupt'", 
			"GPRINT:D:AVERAGE:'%.0lf\g'",
			"STACK:E#F5FFFA:'idle'", 
			"GPRINT:E:AVERAGE:'%.0lf\g'")),
		"detailed" => array(
		    "dsdefinition" => array(
			"DEF:A=".$this->get("rrdfile").":user:AVERAGE",
			"DEF:B=".$this->get("rrdfile").":nice:AVERAGE",
			"DEF:C=".$this->get("rrdfile").":system:AVERAGE",
			"DEF:D=".$this->get("rrdfile").":interrupt:AVERAGE",
			"DEF:E=".$this->get("rrdfile").":idle:AVERAGE"),
		    "graphdefinition" => array(
			'COMMENT:"                 min       avg       max       last\n"',
			"AREA:A#00FF00:'user     '",
			'GPRINT:A:MIN:" %6.2lf %%"',
			'GPRINT:A:AVERAGE:"%6.2lf %%"',
			'GPRINT:A:MAX:"%6.2lf %%"',
			'GPRINT:A:LAST:"%6.2lf %%\n"',
			"STACK:B#00FFFF:'nice     '",
			'GPRINT:B:MIN:" %6.2lf %%"',
			'GPRINT:B:AVERAGE:"%6.2lf %%"',
			'GPRINT:B:MAX:"%6.2lf %%"',
			'GPRINT:B:LAST:"%6.2lf %%\n"',
			"STACK:C#DDA0DD:'system   '",
			'GPRINT:C:MIN:" %6.2lf %%"',
			'GPRINT:C:AVERAGE:"%6.2lf %%"',
			'GPRINT:C:MAX:"%6.2lf %%"',
			'GPRINT:C:LAST:"%6.2lf %%\n"',
			"STACK:D#9932CC:'interrupt'", 
			'GPRINT:D:MIN:" %6.2lf %%"',
			'GPRINT:D:AVERAGE:"%6.2lf %%"',
			'GPRINT:D:MAX:"%6.2lf %%"',
			'GPRINT:D:LAST:"%6.2lf %%\n"',
			"STACK:E#F5FFFA:'idle     '",
			'GPRINT:E:MIN:" %6.2lf %%"',
			'GPRINT:E:AVERAGE:"%6.2lf %%"',
			'GPRINT:E:MAX:"%6.2lf %%"',
			'GPRINT:E:LAST:"%6.2lf %%\n"')))));
	$this->graphdefaults = array_merge($this->graphdefaults, 
					   $this->shortcut["cpu"]["brief"]);
	$this->url2options($url);

    }
}
?>
