#
# This script was written by Noam Rathaus <noamr@securiteam.com>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10263);
 script_version ("$Revision: 1.14.2.3 $");
 
 name["english"] = "SMTP Server type and version";
 script_name(english:name["english"]);
 
 desc["english"] = "This detects the SMTP Server's type and version by connecting to the server
and processing the buffer received.
This information gives potential attackers additional information about the
system they are attacking. Versions and Types should be omitted
where possible.

Solution: Change the login banner to something generic.

Risk factor : Low";

 script_description(english:desc["english"]);
 
 summary["english"] = "SMTP Server type and version";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 1999 SecuriTeam");
 family["english"] = "General";
 script_family(english:family["english"]);

 script_dependencie("find_service.nes");
 script_require_ports("Services/smtp", 25);
 exit(0);
}

#
# The script code starts here
#

port = get_kb_item("Services/smtp");
if (!port) port = 25;

if (get_port_state(port))
{
 soctcp25 = open_sock_tcp(port);

 if (soctcp25)
 {
  resultrecv1 = recv_line(socket:soctcp25, length:1000);

  if(!resultrecv1){
        set_kb_item(name:"SMTP/wrapped", value:TRUE);
        close(soc);
        exit(0);
        }

  if ("qmail" >< resultrecv1)
  {
   set_kb_item(name:"SMTP/qmail", value:TRUE);
  }
  
  if ("Postfix" >< resultrecv1)
  {
   set_kb_item(name:"SMTP/postfix", value:TRUE);
  }
  
  
  if("Sendmail" >< resultrecv1)
  {
   set_kb_item(name:"SMTP/sendmail", value:TRUE);
  }
  
  if("XMail " >< resultrecv1)
  {
   set_kb_item(name:"SMTP/XMail", value:TRUE);
  }
  
  if( (" nbx" >< resultrecv1) && (" Service ready" >< resultrecv1)
  {
   set_kb_item(name:"SMTP/3comnbx", value: TRUE);
  }
  
  if(("Microsoft Exchange Internet Mail Service" >< resultrecv1) ||
     ("NTLM LOGIN" >< resultrecv1))
  {
   set_kb_item(name:"SMTP/microsoft_esmtp_5", value:TRUE);
  }
 
  data = string("Remote SMTP server banner :\n",  resultrecv1);

  security_note(port:port, data:data);
 }

 close(soctcp25);
}
