#
# This script was written by David Lodge
#
# See the Nessus Scripts License for details
#
# Changes by rd:
# - recv() only receives the first two bytes of data (instead of 1024)
# - replaced ord(result[0]) == 0x1E by ord(result[0]) & 0x1E (binary AND)

if(description)
{
 script_id(10884);
 script_version("$Revision: 1.4 $");
 name["english"] = "NTP read variables";
 script_name(english:name["english"]);
 
 desc["english"] = "
It is possible to determine a lot of information about the remote host 
by querying the NTP variables - these include OS descriptor, and 
time settings.

Theoretically one could work out the NTP peer relationships and track back
network settings from this.

Quickfix: Set NTP to restrict default access to ignore all info packets:
	restrict default ignore

Risk factor : Low";

 script_description(english:desc["english"]);
 
 summary["english"] = "NTP allows query of variables";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2002 David Lodge");
 family["english"] = "General";
 script_family(english:family["english"]);

 exit(0);
}

#
# The script code starts here
#
#

# find out whether we can open the port

if( !(get_udp_port_state(123)) ) exit(0);

soc = open_sock_udp(123);
  
if (soc)
{
   data = raw_string( 0x1e, 0x02, 0x00, 0x01,
                      0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00);

   send(socket:soc, data:data);

   # we only care about the first two bytes - the rest is junk!
   result = recv(socket:soc, length:2);

   # check for the response we expect
   if ((ord(result[0]) & 0x1E) && (ord(result[1]) == 0x82))
   {
      security_note(port:123, protocol:"udp");
   }
   close(soc);
}

