if(description)
{
 script_id(10877);
 script_cve_id("CVE-1999-1005");
 script_bugtraq_id(879);
 script_version("$Revision: 1.6.2.1 $");
 name["english"] = "GroupWise Web Interface 'HELP' hole";
 script_name(english:name["english"]);
 
 desc["english"] = "
By modifying the GroupWise Web Interface HELP URL request,
it is possible to gain additional information on the
remote computer and even read local files from its hard
drive.

Risk factor : High
Solution : Contact your vendor for a patch
See also : http://www.securiteam.com/exploits/3I5QDQ0QAG.html
";

 script_description(english:desc["english"]);
 
 summary["english"] = "GroupWise Web Interface 'HELP' hole";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2002 SecurITeam");
 family["english"] = "CGI abuses";
 script_family(english:family["english"]);
 script_dependencie("find_service.nes", "no404.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

# Check starts here

include("http_func.inc");

function check(req)
{
 soc = http_open_socket(port);
 if(soc)
 {

  req = http_get(item:req, port:port);

  send(socket:soc, data:req);
  buf = http_recv(socket:soc);

  http_close_socket(soc);

  if (("Could not find file SYS" >< buf))
  {
   	security_hole(port:port);
	return(1);
  }
 }
 return(0);
}

port = get_kb_item("Services/www");
if(!port)port = 80;

cginameandpath[0] = string("/GW5/GWWEB.EXE?HELP=bad-request");
cginameandpath[1] = string("/GWWEB.EXE?HELP=bad-request");
cginameandpath[2] = "";

i = 0;
if(get_port_state(port))
{
 for (i = 0; cginameandpath[i]; i = i + 1)
 { 
  url = cginameandpath[i];
  if(check(req:url))exit(0);
 }
}


cgibin = cgibin();
cginameandpath[0] = string(cgibin, "/GW5/GWWEB.EXE?HELP=bad-request");
cginameandpath[1] = string(cgibin, "/GWWEB.EXE?HELP=bad-request");
cginameandpath[2] = "";
i = 0;
if(get_port_state(port))
{
 for (i = 0; cginameandpath[i]; i = i + 1)
 { 
  url = cginameandpath[i];
  if(check(req:url))exit(0);
 }
}
