# This script was written by John Lampe...j_lampe@bellsouth.net
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10942);
 script_version("$Revision: 1.3.2.1 $");
 name["english"] = "Check for a Citrix server";
 script_name(english:name["english"]);

 desc["english"] = "
A Citrix server is running on this machine.

Citrix servers allow a Windows user to remotely
obtain a graphical login (and therefore act as a local
user on the remote host).

If an attacker gains a valid login and password, he may
be able to use this service to gain further access on
the remote host

Solution: Disable this service if you do not use it. Also, make sure
that the SECURE ICA option pack has been installed

Risk factor : Low";

 script_description(english:desc["english"]);

 summary["english"] = "CITRIX check";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"This script is Copyright (C) 2002 John Lampe...j_lampe@bellsouth.net");
 family["english"] = "Useless services";
 script_family(english:family["english"]);
 exit(0);
}

#
# The script code starts here
#





function check_setting(port) {
 if(!get_port_state(port))exit(0);
 soc = open_sock_tcp(port);
 if(soc) {
    r = recv(socket:soc, length:64);
    if ((egrep(pattern:".*ICA.*", string:r))) {
        security_note(port);
    }
    close(soc);
 }
}

port = 1494;
check_setting(port:port);
