<?php
// $Horde: kronolith/lib/api.php,v 1.28.2.3 2002/05/17 22:58:16 jan Exp $
/*
 * Kronolith external API interface.
 *
 * This file defines Kronolith's external API interface. Other
 * applications can interact with Kronolith through this API.
 */

// Find the base file paths for Kronolith
@define('KRONOLITH_BASE', dirname(__FILE__) . '/..');

// Include the necessary libraries.
require_once KRONOLITH_BASE . '/lib/base.php';

function kronolithSummary()
{
    global $prefs, $registry;

    $html  = '<table border="0" cellpadding="2" cellspacing="0" width="100%"><tr><td class="header">';
    $html .= Horde::link(Horde::url($registry->getInitialPage()), $registry->getParam('name'), 'header') . $registry->getParam('name') . '</a> - ';
    $html .= Horde::link(Horde::applicationUrl('addevent.php'), _("New Event"), 'smallheader') . Horde::img('new.gif', 'alt="' . _("New Event") . '"') . _("New Event") . '</a>';
    $html .= '</td></tr><tr><td class="text"><table border="0" cellpadding="0" cellspacing="0">';

    include_once KRONOLITH_BASE . '/lib/Day.php';
    $day = new Kronolith_Day();
    $now = time();
    for ($i = 0; $i < $prefs->getValue('summary_days'); $i++) {
        $events = Kronolith::getEvents($day);
        $firstevent = true;
        $htmldays = array();

        $today12am = mktime(0, 0, 0, $day->month, $day->mday, $day->year);
        $tomorrow12am = mktime(0, 0, 0, $day->month, $day->mday + 1, $day->year);
        foreach ($events as $event) {
            if (!$event->hasRecurType(KRONOLITH_RECUR_NONE)) {
                $event->startTimestamp = mktime($event->start->hour, $event->start->min, $event->start->sec, $day->month, $day->mday, $day->year);
                $event->endTimestamp = $event->startTimestamp + $event->durMin * 60;
            } else {
                if ($event->startTimestamp < $today12am) {
                    $event->startTimestamp = $today12am;
                }
                if ($event->endTimestamp >= $tomorrow12am) {
                    $event->endTimestamp = $tomorrow12am;
                }
            }
            if ($event->endTimestamp < $now) continue;
            if ($prefs->getValue('summary_alarms') && !$event->alarm) continue;
            if ($firstevent) {
                $html .= '<tr><td colspan="3" class="text"><b>';
                if ($day->isToday()) {
                    $html .= _("Today");
                } else {
                    $html .= strftime($prefs->getValue('date_format'), $day->getStamp());
                }
                $html .= '</b></td></tr>';
                $firstevent = false;
            }
            $htmlday = '<tr><td class="text" nowrap="nowrap" valign="top">';
            if ($event->startTimestamp < $now && $event->endTimestamp > $now) {
                $htmlday .= '<b>';
            }

            /* The following check to make sure the start time is not
               12AM was changed to use the getStartDate function to
               get the startTimestamp hour and min instead of using
               start->hour and start->min. When using the SQL driver
               this change properly lists a multiday event as 'All
               day' if it spans the entire day. It shouldn't affect
               the mcal driver since in the case of the mcal driver
               the startTimestamp hour and min are the same as
               start->hour and start->min. */
            if ($event->getStartDate('G') != 0 ||
                $event->getStartDate('i') != 0 ||
                (($event->endTimestamp - $event->startTimestamp) % (24 * 60 * 60)) != 0) {
                if ($prefs->getValue('twentyFour')) {
                    $time  = date('G:i', $event->startTimestamp) . '-';
                    $time .= date('G:i', $event->endTimestamp);
                } else {
                    $time  = date('g:i A', $event->startTimestamp) . '-';
                    $time .= date('g:i A', $event->endTimestamp);
                }
            } else {
                $time = _("All day event");
            }

            $text = $event->title;
            if (!empty($event->location)) {
                $text .= ' (' . $event->location . ')';
            }
            if (isset($event->eventID)) {
                $htmlday .= Horde::link(Horde::applicationUrl('viewevent.php?eventID=' .
                                                              $event->eventID), $event->title) . $time . '</a>';
            } elseif (isset($event->taskID)) {
                $htmlday .= Horde::link(Horde::url($registry->link('tasks/show',
                                                                   array('task' => $event->taskID)),
                                                   $event->title)) . $time . '</a>';
            } else {
                $htmlday .= $time;
            }
            if ($event->startTimestamp < $now && $event->endTimestamp > $now) $htmlday .= '</b>';
            $htmlday .= '</td><td class="text">&nbsp;&nbsp;&nbsp;</td><td class="text">';
            if ($event->startTimestamp < $now && $event->endTimestamp > $now) $htmlday .= '<b>';
            if (isset($event->eventID)) {
                $htmlday .= Horde::link(Horde::applicationUrl('viewevent.php?eventID=' .
                                                              $event->eventID), $event->title) . $text . '</a>';
            } elseif (isset($event->taskID)) {
                $htmlday .= Horde::link(Horde::url($registry->link('tasks/show', array('task' => $event->taskID))), $event->title) . $text . '</a>';
            } else {
                $htmlday .= $text;
            }
            if ($event->startTimestamp < $now && $event->endTimestamp > $now) $html .= '</b>';
            $htmlday .= '</td></tr>';
			while (isset($htmldays[$event->startTimestamp])) {
				$event->startTimestamp++;
			}
			$htmldays[$event->startTimestamp] = $htmlday;
        }
        ksort($htmldays);
		$html .= implode("\n", $htmldays);
        $day = new Kronolith_Day(null, null, null, $day->getTomorrow());
    }
    $html .= '</table></td></tr></table>';

    return $html;
}

?>
