#!/usr/bin/perl -w
#
# $Horde: horde/scripts/mime_mapping/convert.pl,v 1.4.2.2 2002/06/26 18:48:53 jan Exp $
#
# Copyright 2001 Anil Madhavapeddy <anil@recoil.org>
#
# See the enclosed file COPYING for license information (GPL).  If you
# did not receive this file, see http://www.fsf.org/copyleft/gpl.html.

use strict;

my %exts = ();

# Map the mime.types file into the %ext hash
while (<>) {
	chomp;
	next if /^#/;
	my @fields = split /\s+/;
	for (my $i=1; $i <= $#fields; $i++) {
           $exts{$fields[$i]} = $fields[0];
	}
}

# Assemble it into an output array
my @out = ();
my @exts = sort keys %exts;
foreach my $ext (@exts) {
	push @out, "'$ext'\t => '$exts{$ext}'";
}

# Implode the output array into a PHP file.
print << 'HEADER';
<?php
// $Horde: horde/scripts/mime_mapping/convert.pl,v 1.4.2.2 2002/06/26 18:48:53 jan Exp $

/**
 * This file contains a mapping of common file extensions to
 * MIME types. It has been automatically generated from the
 * horde/scripts/mime_mapping directory.
 *
 * Any unknown file extensions will automatically be mapped to
 * 'x-extension/<ext>' where <ext> is the unknown file extension.
 */

$mime_extension_map = array(

HEADER
print join(",\n",@out);
print << 'FOOTER';

);
FOOTER
