/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
#ifndef _ERL_MALLOC_H
#define _ERL_MALLOC_H
/* Copyright (C) 1996 Ericsson Telecom
 * Created: 7 May 1996 by tobbe@erix.ericsson.se 
 */
#include "erl_eterm.h"

#ifdef __STDC__
extern void erl_init_malloc(Erl_Heap*,long);
extern void *erl_malloc(long);
extern void erl_free(void*);
extern ETERM *erl_alloc_eterm(unsigned char);
extern void erl_free_term(ETERM*);
extern void erl_free_compound(ETERM*);
extern void erl_free_array(ETERM**,int);
extern int erl_current_fix_desc(void);
#else
extern void erl_init_malloc();
extern void *erl_malloc();
extern void erl_free();
extern ETERM *erl_alloc_eterm();
extern void erl_free_term();
extern void erl_free_compound();
extern void erl_free_array();
extern int erl_current_fix_desc();
#endif

#endif

