require '_h2ph_pre.ph';

unless(defined(&_SYS_TYPES_H_)) {
    eval 'sub _SYS_TYPES_H_ () {1;}' unless defined(&_SYS_TYPES_H_);
    require 'machine/types.ph';
    require 'machine/ansi.ph';
    require 'machine/endian.ph';
    if(!defined( &_POSIX_SOURCE)  && !defined( &_XOPEN_SOURCE)) {
    }
    if(defined(&_BSD_CLOCK_T_)) {
	undef(&_BSD_CLOCK_T_) if defined(&_BSD_CLOCK_T_);
    }
    if(defined(&_BSD_SIZE_T_)) {
	undef(&_BSD_SIZE_T_) if defined(&_BSD_SIZE_T_);
    }
    if(defined(&_BSD_SSIZE_T_)) {
	undef(&_BSD_SSIZE_T_) if defined(&_BSD_SSIZE_T_);
    }
    if(defined(&_BSD_TIME_T_)) {
	undef(&_BSD_TIME_T_) if defined(&_BSD_TIME_T_);
    }
    if(defined(&_BSD_CLOCKID_T_)) {
	undef(&_BSD_CLOCKID_T_) if defined(&_BSD_CLOCKID_T_);
    }
    if(defined(&_BSD_TIMER_T_)) {
	undef(&_BSD_TIMER_T_) if defined(&_BSD_TIMER_T_);
    }
    if(defined(&_BSD_OFF_T_)) {
	undef(&_BSD_OFF_T_) if defined(&_BSD_OFF_T_);
    }
    if(!defined( &_POSIX_SOURCE)  && !defined( &_XOPEN_SOURCE)) {
	unless(defined(&_KERNEL)) {
	    require 'sys/cdefs.ph';
	}
    }
    if(!defined( &_POSIX_SOURCE)  && !defined( &_XOPEN_SOURCE)) {
	eval 'sub major {
	    local($x) = @_;
    	    eval q((((($x) >> 8) & 0xff)));
	}' unless defined(&major);
	eval 'sub minor {
	    local($x) = @_;
    	    eval q(((($x) & 0xff) | ((($x) & 0xffff0000) >> 8)));
	}' unless defined(&minor);
	eval 'sub makedev {
	    local($x,$y) = @_;
    	    eval q(((((($x) & 0xff) << 8) | (($y) & 0xff) | ((($y) & 0xffff00) << 8))));
	}' unless defined(&makedev);
    }
    if(!defined( &_POSIX_SOURCE)  && !defined( &_XOPEN_SOURCE)) {
	eval 'sub NBBY () {8;}' unless defined(&NBBY);
	unless(defined(&FD_SETSIZE)) {
	    eval 'sub FD_SETSIZE () {1024;}' unless defined(&FD_SETSIZE);
	}
	eval 'sub NFDBITS () {($sizeof{ &fd_mask} *  &NBBY);}' unless defined(&NFDBITS);
	unless(defined(&howmany)) {
	    eval 'sub howmany {
	        local($x, $y) = @_;
    		eval q(((($x) + (($y) - 1)) / ($y)));
	    }' unless defined(&howmany);
	}
	eval 'sub FD_SET {
	    local($n, $p) = @_;
    	    eval q((($p)-> $fds_bits[($n)/ &NFDBITS] |= (1<< (($n) %  &NFDBITS))));
	}' unless defined(&FD_SET);
	eval 'sub FD_CLR {
	    local($n, $p) = @_;
    	    eval q((($p)-> $fds_bits[($n)/ &NFDBITS] &= ~(1<< (($n) %  &NFDBITS))));
	}' unless defined(&FD_CLR);
	eval 'sub FD_ISSET {
	    local($n, $p) = @_;
    	    eval q((($p)-> $fds_bits[($n)/ &NFDBITS] & (1<< (($n) %  &NFDBITS))));
	}' unless defined(&FD_ISSET);
	if(defined(&_KERNEL)) {
	    eval 'sub FD_COPY {
	        local($f, $t) = @_;
    		eval q( &bcopy($f, $t, $sizeof{($f)}));
	    }' unless defined(&FD_COPY);
	    eval 'sub FD_ZERO {
	        local($p) = @_;
    		eval q( &bzero($p, $sizeof{($p)}));
	    }' unless defined(&FD_ZERO);
	} else {
	    eval 'sub FD_COPY {
	        local($f, $t) = @_;
    		eval q( &memcpy($t, $f, $sizeof{($f)}));
	    }' unless defined(&FD_COPY);
	    eval 'sub FD_ZERO {
	        local($p) = @_;
    		eval q( &memset($p, 0, $sizeof{($p)}));
	    }' unless defined(&FD_ZERO);
	}
	if(defined( &__STDC__)  && defined( &_KERNEL)) {
	}
    }
}
1;
