require '_h2ph_pre.ph';

unless(defined(&osiop_read_1)) {
    sub osiop_read_1 {
	local($sc, $reg) = @_;
	eval q( &bus_space_read_1(($sc)-> &sc_bst, ($sc)-> &sc_reg, $reg));
    }
}
unless(defined(&osiop_write_1)) {
    sub osiop_write_1 {
	local($sc, $reg, $val) = @_;
	eval q( &bus_space_write_1(($sc)-> &sc_bst, ($sc)-> &sc_reg, $reg, $val));
    }
}
unless(defined(&osiop_read_4)) {
    sub osiop_read_4 {
	local($sc, $reg) = @_;
	eval q( &bus_space_read_4(($sc)-> &sc_bst, ($sc)-> &sc_reg, $reg));
    }
}
unless(defined(&osiop_write_4)) {
    sub osiop_write_4 {
	local($sc, $reg, $val) = @_;
	eval q( &bus_space_write_4(($sc)-> &sc_bst, ($sc)-> &sc_reg, $reg, $val));
    }
}
unless(defined(&OSIOP_NSG)) {
    sub OSIOP_NSG () {	(16+ 1);}
}
if((defined(&MAXPHYS) ? &MAXPHYS : 0) > ((defined(&PAGE_SIZE) ? &PAGE_SIZE : 0) * ((defined(&OSIOP_NSG) ? &OSIOP_NSG : 0) - 1))) {
    eval 'sub OSIOP_MAX_XFER () {( &PAGE_SIZE * ( &OSIOP_NSG - 1));}' unless defined(&OSIOP_MAX_XFER);
} else {
    eval 'sub OSIOP_MAX_XFER () { &MAXPHYS;}' unless defined(&OSIOP_MAX_XFER);
}
unless(defined(&OSIOP_NTGT)) {
    sub OSIOP_NTGT () {	8;}
}
unless(defined(&OSIOP_NACB)) {
    sub OSIOP_NACB () {	32;}
}
unless(defined(&SCSI_OSIOP_NOCHECK)) {
    sub SCSI_OSIOP_NOCHECK () {	0xfe;}
}
unless(defined(&SCSI_OSIOP_NOSTATUS)) {
    sub SCSI_OSIOP_NOSTATUS () {	0xff;}
}
unless(defined(&MSG_INVALID)) {
    sub MSG_INVALID () {	0xff;}
}
unless(defined(&OSIOP_DSOFF)) {
    sub OSIOP_DSOFF {
	local($x) = @_;
	eval q( &offsetof('struct osiop_ds', $x));
    }
}
unless(defined(&OSIOP_DSIDOFF)) {
    sub OSIOP_DSIDOFF () {	 &OSIOP_DSOFF( $msgout[0]);}
}
unless(defined(&OSIOP_DSMSGOFF)) {
    sub OSIOP_DSMSGOFF () {	 &OSIOP_DSOFF( $msgbuf[0]);}
}
unless(defined(&OSIOP_DSMSGINOFF)) {
    sub OSIOP_DSMSGINOFF () {	 &OSIOP_DSOFF( $msgbuf[1]);}
}
unless(defined(&OSIOP_DSEXTMSGOFF)) {
    sub OSIOP_DSEXTMSGOFF () {	 &OSIOP_DSOFF( $msgbuf[2]);}
}
unless(defined(&OSIOP_DSSYNMSGOFF)) {
    sub OSIOP_DSSYNMSGOFF () {	 &OSIOP_DSOFF( $msgbuf[3]);}
}
unless(defined(&OSIOP_DSSTATOFF)) {
    sub OSIOP_DSSTATOFF () {	 &OSIOP_DSOFF( $stat[0]);}
}
unless(defined(&OSIOP_DSCMDOFF)) {
    sub OSIOP_DSCMDOFF () {	 &OSIOP_DSOFF( &scsi_cmd);}
}
unless(defined(&ACB_S_FREE)) {
    sub ACB_S_FREE () {	0;}
}
unless(defined(&ACB_S_READY)) {
    sub ACB_S_READY () {	1;}
}
unless(defined(&ACB_S_ACTIVE)) {
    sub ACB_S_ACTIVE () {	2;}
}
unless(defined(&ACB_S_DONE)) {
    sub ACB_S_DONE () {	3;}
}
unless(defined(&ACB_F_TIMEOUT)) {
    sub ACB_F_TIMEOUT () {	0x1;}
}
unless(defined(&ACB_F_AUTOSENSE)) {
    sub ACB_F_AUTOSENSE () {	0x2;}
}
unless(defined(&TI_NOSYNC)) {
    sub TI_NOSYNC () {	0x1;}
}
unless(defined(&TI_NODISC)) {
    sub TI_NODISC () {	0x2;}
}
unless(defined(&OSIOP_INTSOFF)) {
    sub OSIOP_INTSOFF () {	0x80;}
}
unless(defined(&OSIOP_INTDEFER)) {
    sub OSIOP_INTDEFER () {	0x40;}
}
unless(defined(&OSIOP_NODMA)) {
    sub OSIOP_NODMA () {	0x2;}
}
unless(defined(&OSIOP_ALIVE)) {
    sub OSIOP_ALIVE () {	0x1;}
}
unless(defined(&NEG_INIT)) {
    sub NEG_INIT () {	0;}
}
unless(defined(&NEG_SYNC)) {
    sub NEG_SYNC () {	 &NEG_INIT;}
}
unless(defined(&NEG_WAITS)) {
    sub NEG_WAITS () {	1;}
}
unless(defined(&NEG_DONE)) {
    sub NEG_DONE () {	2;}
}
1;
